/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.annex;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import de.digitalcollections.iiif.model.Service;
import java.net.URI;
import org.geojson.Feature;

public class GeoService
extends Service {
    public static final String CONTEXT = "http://geojson.org/geojson-ld/geojson-context.jsonld";
    @JsonUnwrapped
    private Feature feature;

    public GeoService() {
        super(URI.create(CONTEXT));
    }

    public GeoService(String identifier) {
        this();
        this.setIdentifier(URI.create(identifier));
    }

    public GeoService(Feature feature) {
        this(null, feature);
    }

    public GeoService(String identifier, Feature feature) {
        this(identifier);
        if (!this.isFeatureEmpty(feature)) {
            this.feature = feature;
        }
    }

    public String getType() {
        if (!this.isFeatureEmpty(this.feature)) {
            return "Feature";
        }
        return null;
    }

    public Feature getFeature() {
        return this.feature;
    }

    private boolean isFeatureEmpty(Feature feature) {
        return feature == null || feature.getGeometry() == null && feature.getProperties().isEmpty();
    }
}

