/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.PropertyValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonPropertyOrder(value={"@context", "@id", "@type"})
public abstract class Service {
    @JsonProperty(value="@context")
    private URI context;
    @JsonProperty(value="@id")
    private URI identifier;
    @JsonProperty(value="profile")
    private List<Profile> profiles;
    private PropertyValue label;

    @JsonCreator
    public Service(@JsonProperty(value="@context") URI context) {
        this.context = context;
    }

    public Service(URI context, String identifier) {
        this(context);
        this.identifier = URI.create(identifier);
    }

    public URI getContext() {
        return this.context;
    }

    public void setContext(URI context) {
        this.context = context;
    }

    public URI getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(URI identifier) {
        this.identifier = identifier;
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<Profile> profile) {
        this.profiles = profile;
    }

    public Service addProfile(Profile first, Profile ... rest) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<Profile>();
        }
        this.profiles.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public Service addProfile(String first, String ... rest) {
        return this.addProfile(new Profile(URI.create(first)), (Profile[])Arrays.stream(rest).map(p -> new Profile(URI.create(p))).toArray(Profile[]::new));
    }

    public PropertyValue getLabel() {
        return this.label;
    }

    @JsonIgnore
    public String getLabelString() {
        return this.label.getFirstValue();
    }

    public void setLabel(PropertyValue label) {
        this.label = label;
    }

    public void setLabel(String label) {
        this.setLabel(new PropertyValue(label, new String[0]));
    }
}

