/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.digitalcollections.iiif.model.GenericService;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.Service;
import de.digitalcollections.iiif.model.annex.GeoService;
import de.digitalcollections.iiif.model.annex.PhysicalDimensionsService;
import de.digitalcollections.iiif.model.auth.AccessCookieService;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.ImageService;
import de.digitalcollections.iiif.model.image.Size;
import de.digitalcollections.iiif.model.image.TileInfo;
import de.digitalcollections.iiif.model.search.AutocompleteService;
import de.digitalcollections.iiif.model.search.ContentSearchService;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ServiceDeserializer
extends JsonDeserializer<Service> {
    public Service deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
            return new GenericService(null, p.getValueAsString());
        }
        ObjectNode obj = (ObjectNode)mapper.readTree(p);
        if (this.isV1ImageService(obj)) {
            return this.parseV1Service(obj);
        }
        if (this.isImageService(obj)) {
            return (Service)mapper.treeToValue((TreeNode)obj, ImageService.class);
        }
        String context = null;
        if (obj.has("@context")) {
            context = obj.get("@context").asText();
        }
        JsonNode profileNode = obj.get("profile");
        String profile = null;
        if (profileNode != null) {
            profile = profileNode.asText();
        }
        if (Objects.equals(context, "http://iiif.io/api/search/1/context.json")) {
            if (Objects.equals(profile, "http://iiif.io/api/search/1/autocomplete")) {
                return (Service)mapper.treeToValue((TreeNode)obj, AutocompleteService.class);
            }
            return (Service)mapper.treeToValue((TreeNode)obj, ContentSearchService.class);
        }
        if (Objects.equals(context, "http://iiif.io/api/auth/1/context.json")) {
            return (Service)mapper.treeToValue((TreeNode)obj, AccessCookieService.class);
        }
        if (Objects.equals(context, "http://geojson.org/geojson-ld/geojson-context.jsonld")) {
            return (Service)mapper.treeToValue((TreeNode)obj, GeoService.class);
        }
        if (Objects.equals(context, "http://iiif.io/api/annex/services/physdim/1/context.json")) {
            return (Service)mapper.treeToValue((TreeNode)obj, PhysicalDimensionsService.class);
        }
        return (Service)mapper.treeToValue((TreeNode)obj, GenericService.class);
    }

    private ImageService parseV1Service(ObjectNode obj) {
        ImageService service = new ImageService(obj.get("@id").asText());
        if (obj.has("@context")) {
            service.setContext(URI.create(obj.get("@context").asText()));
        }
        if (obj.has("profile")) {
            service.addProfile(ImageApiProfile.fromUrl(obj.get("profile").asText()), new Profile[0]);
        } else if (obj.has("dcterms:conformsTo")) {
            service.addProfile(ImageApiProfile.fromUrl(obj.get("dcterms:conformsTo").asText()), new Profile[0]);
        }
        if (obj.has("width")) {
            service.setWidth(obj.get("width").asInt());
        }
        if (obj.has("height")) {
            service.setHeight(obj.get("height").asInt());
        }
        if (obj.has("scale_factors") && service.getWidth() != null && service.getHeight() != null) {
            obj.withArray("scale_factors").forEach(fnode -> service.addSize(new Size(service.getWidth() / fnode.asInt(), service.getHeight() / fnode.asInt()), new Size[0]));
        }
        if (obj.has("tile_width") && obj.has("scale_factors")) {
            TileInfo tinfo = new TileInfo(obj.get("tile_width").asInt());
            obj.withArray("scale_factors").forEach(fnode -> tinfo.addScaleFactor(fnode.asInt(), new Integer[0]));
            if (obj.has("tile_height")) {
                tinfo.setHeight(obj.get("tile_height").intValue());
            }
            service.addTile(tinfo, new TileInfo[0]);
        }
        if (obj.has("formats") || obj.has("qualities")) {
            ImageApiProfile profile = new ImageApiProfile();
            if (obj.has("formats")) {
                obj.withArray("formats").forEach(f -> profile.addFormat(ImageApiProfile.Format.valueOf(f.asText().toUpperCase()), new ImageApiProfile.Format[0]));
            }
            if (obj.has("qualities")) {
                List<String> qualities = StreamSupport.stream(obj.withArray("qualities").spliterator(), false).map(q -> q.asText().equals("native") ? "default" : q.asText()).map(q -> q.equals("grey") ? "gray" : q).collect(Collectors.toList());
                qualities.forEach(q -> profile.addQuality(ImageApiProfile.Quality.valueOf(q.toUpperCase()), new ImageApiProfile.Quality[0]));
            }
            service.addProfile(profile, new Profile[0]);
        }
        return service;
    }

    private boolean isV1ImageService(ObjectNode node) {
        String profile;
        if (node.has("profile")) {
            profile = node.get("profile").asText();
        } else if (node.has("dcterms:conformsTo")) {
            profile = node.get("dcterms:conformsTo").asText();
            profile = profile.replace("conformance", "compliance");
        } else {
            return false;
        }
        return ImageApiProfile.V1_PROFILES.contains(profile);
    }

    public boolean isImageService(ObjectNode node) {
        JsonNode ctxNode = node.get("@context");
        JsonNode profileNode = node.get("profile");
        if (ctxNode != null && "http://iiif.io/api/image/2/context.json".equals(ctxNode.textValue())) {
            return true;
        }
        if (profileNode != null) {
            return ImageApiProfile.V1_PROFILES.contains(profileNode.asText());
        }
        return false;
    }
}

