/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.impl.IndexedListSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.jackson.serialization.IiifIndexedListSerializer;
import de.digitalcollections.iiif.model.jackson.serialization.ProfileSerializer;
import de.digitalcollections.iiif.model.jackson.serialization.ResourceSerializer;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.util.ArrayList;

public class SerializerModifier
extends BeanSerializerModifier {
    public JsonSerializer<?> modifyCollectionSerializer(SerializationConfig config, CollectionType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (valueType.getRawClass() == ArrayList.class) {
            return new IiifIndexedListSerializer((IndexedListSerializer)serializer, config.getTypeFactory());
        }
        return super.modifyCollectionSerializer(config, valueType, beanDesc, serializer);
    }

    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (Resource.class.isAssignableFrom(beanDesc.getBeanClass())) {
            return new ResourceSerializer(serializer);
        }
        if (Profile.class.isAssignableFrom(beanDesc.getBeanClass())) {
            return new ProfileSerializer(serializer);
        }
        return super.modifySerializer(config, beanDesc, serializer);
    }
}

