/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.geojson.Feature;

public class ProblemHandler
extends DeserializationProblemHandler {
    public Object handleMissingInstantiator(DeserializationContext ctxt, Class<?> instClass, ValueInstantiator valueInsta, JsonParser p, String msg) throws IOException {
        if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
            // empty if block
        }
        try {
            if (p.getValueAsString().isEmpty() && Collection.class.isAssignableFrom(instClass)) {
                return instClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Constructor<?> constructor = instClass.getConstructor(String.class);
            return constructor.newInstance(p.getValueAsString());
        }
        catch (Exception exception) {
            return super.handleMissingInstantiator(ctxt, instClass, valueInsta, p, msg);
        }
    }

    public Object handleUnexpectedToken(DeserializationContext ctxt, Class<?> targetType, JsonToken t, JsonParser p, String failureMsg) throws IOException {
        ObjectMapper mapper;
        String typeName;
        if (p.getCurrentName().equals("@type") && t == JsonToken.START_ARRAY && (typeName = (String)StreamSupport.stream(((ArrayNode)(mapper = (ObjectMapper)p.getCodec()).readTree(p)).spliterator(), false).map(JsonNode::textValue).filter(v -> !v.equals("cnt:ContentAsText")).findFirst().orElse(null)) != null) {
            return typeName;
        }
        return super.handleUnexpectedToken(ctxt, targetType, t, p, failureMsg);
    }

    public JavaType handleMissingTypeId(DeserializationContext ctxt, JavaType baseType, TypeIdResolver idResolver, String failureMsg) throws IOException {
        if (baseType.getRawClass() == Feature.class) {
            return idResolver.typeFromId((DatabindContext)ctxt, "Feature");
        }
        return super.handleMissingTypeId(ctxt, baseType, idResolver, failureMsg);
    }

    public Object handleWeirdStringValue(DeserializationContext ctxt, Class<?> targetType, String valueToConvert, String failureMsg) throws IOException {
        if (targetType.isEnum()) {
            String lowerCased = valueToConvert.toLowerCase();
            Optional<Object> match = Arrays.stream(targetType.getEnumConstants()).filter(v -> v.toString().toLowerCase().equals(valueToConvert.toLowerCase())).findFirst();
            if (match.isPresent()) {
                return match.get();
            }
        }
        return super.handleWeirdStringValue(ctxt, targetType, valueToConvert, failureMsg);
    }
}

