/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.StdConverter;
import de.digitalcollections.core.model.api.MimeType;
import de.digitalcollections.iiif.model.jackson.DeserializerModifier;
import de.digitalcollections.iiif.model.jackson.SerializerModifier;
import java.util.function.Function;

public class IiifModule
extends SimpleModule {
    public IiifModule() {
        super("iiif-module");
        this.setSerializerModifier(new SerializerModifier());
        this.setDeserializerModifier(new DeserializerModifier());
        this.addSerializer((JsonSerializer)new StdDelegatingSerializer(MimeType.class, this.toString(MimeType::getTypeName)));
        this.addDeserializer(MimeType.class, (JsonDeserializer)new StdDelegatingDeserializer(this.fromString(MimeType::fromTypename)));
    }

    private <T> Converter<String, T> fromString(final Function<String, ? extends T> fun) {
        return new StdConverter<String, T>(){

            public T convert(String value) {
                return fun.apply(value);
            }
        };
    }

    private <T> Converter<T, String> toString(final Function<T, String> fun) {
        return new StdConverter<T, String>(){

            public String convert(T value) {
                return (String)fun.apply(value);
            }
        };
    }
}

