/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.annex;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import de.digitalcollections.iiif.model.Service;
import java.net.URI;

public class PhysicalDimensionsService
extends Service {
    public static final String CONTEXT = "http://iiif.io/api/annex/services/physdim/1/context.json";
    public static final String PROFILE = "http://iiif.io/api/annex/services/physdim";
    private final double physicalScale;
    private final Unit physicalUnits;

    @JsonCreator
    public PhysicalDimensionsService(@JsonProperty(value="physicalScale") double physicalScale, @JsonProperty(value="physicalUnits") Unit units) {
        super(URI.create(CONTEXT));
        this.addProfile(PROFILE, new String[0]);
        this.physicalScale = physicalScale;
        this.physicalUnits = units;
    }

    public PhysicalDimensionsService(String identifier, double physicalScale, Unit units) {
        this(physicalScale, units);
        this.setIdentifier(URI.create(identifier));
    }

    public double getPhysicalScale() {
        return this.physicalScale;
    }

    public Unit getPhysicalUnits() {
        return this.physicalUnits;
    }

    public static enum Unit {
        MILLIMETERS("mm"),
        CENTIMETERS("cm"),
        INCHES("in");

        private final String unit;

        @JsonCreator
        private Unit(String unit) {
            this.unit = unit;
        }

        @JsonValue
        public String toString() {
            return this.unit;
        }
    }
}

