/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.digitalcollections.core.model.api.MimeType;
import de.digitalcollections.iiif.model.Service;
import de.digitalcollections.iiif.model.image.ImageService;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.net.URI;

public class ImageContent
extends Resource<ImageContent> {
    public static final String TYPE = "dctypes:Image";
    @JsonIgnore
    public String _type = "dctypes:Image";
    private MimeType format;
    private Integer width;
    private Integer height;
    private URI profile;

    @JsonCreator
    public ImageContent(@JsonProperty(value="@id") String identifier) {
        super(identifier);
        this.setFormat(MimeType.fromURI((URI)this.getIdentifier()));
    }

    public ImageContent(ImageService service) {
        this(String.format("%s/full/full/0/default.jpg", service.getIdentifier()));
        this.addService(service, new Service[0]);
    }

    @Override
    public String getType() {
        return this._type;
    }

    public MimeType getFormat() {
        return this.format;
    }

    public void setFormat(MimeType format) {
        this.format = format;
    }

    public void setFormat(String format) {
        this.format = MimeType.fromTypename((String)format);
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public URI getProfile() {
        return this.profile;
    }

    public void setProfile(URI profile) {
        this.profile = profile;
    }
}

