/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableSet;
import de.digitalcollections.iiif.model.ImageContent;
import de.digitalcollections.iiif.model.ModelUtilities;
import de.digitalcollections.iiif.model.Motivation;
import de.digitalcollections.iiif.model.openannotation.Annotation;
import de.digitalcollections.iiif.model.sharedcanvas.Canvas;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ResourceSerializer
extends JsonSerializer<Resource> {
    private final JsonSerializer<Object> defaultSerializer;

    public ResourceSerializer(JsonSerializer<Object> defaultSerializer) {
        this.defaultSerializer = defaultSerializer;
    }

    public void serialize(Resource value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        Object parent;
        if (gen.getOutputContext().getParent() == null) {
            value._context = "http://iiif.io/api/presentation/2/context.json";
        }
        if (value.getAlternatives() != null && !value.getAlternatives().isEmpty()) {
            gen.writeStartObject();
            gen.writeStringField("@type", "oa:Choice");
            gen.writeFieldName("default");
            List alternatives = value.getAlternatives();
            value.setAlternatives(null);
            this.defaultSerializer.serialize((Object)value, gen, serializers);
            gen.writeArrayFieldStart("item");
            for (Resource alt : alternatives) {
                this.defaultSerializer.serialize((Object)alt, gen, serializers);
            }
            gen.writeEndArray();
            gen.writeEndObject();
            return;
        }
        String containingField = ResourceSerializer.getContainingField(gen);
        String typeBackup = null;
        if (ImmutableSet.of((Object)"thumbnail", (Object)"logo").contains((Object)containingField)) {
            ImageContent imgContent = (ImageContent)value;
            typeBackup = imgContent._type;
            imgContent._type = null;
        }
        String parentType = null;
        if (gen.getCurrentValue() != null) {
            parent = gen.getCurrentValue();
            if (parent instanceof Resource) {
                parentType = ((Resource)parent).getType();
            }
        } else if (gen.getOutputContext() != null && gen.getOutputContext().getParent() != null && (parent = gen.getOutputContext().getParent().getCurrentValue()) instanceof Resource) {
            parentType = ((Resource)parent).getType();
        }
        ModelUtilities.Completeness completeness = ModelUtilities.getCompleteness(value, value.getClass());
        if (Objects.equals(containingField, "canvases") && completeness == ModelUtilities.Completeness.ID_AND_TYPE) {
            completeness = ModelUtilities.Completeness.ID_ONLY;
        }
        if (Objects.equals(containingField, "within") && completeness == ModelUtilities.Completeness.ID_AND_TYPE) {
            boolean skipType;
            String withinType = value.getType();
            boolean bl = skipType = "sc:Manifest".equals(parentType) && "sc:Collection".equals(withinType) || "sc:AnnotationList".equals(parentType) && "sc:Layer".equals(withinType) || "sc:Collection".equals(parentType) && "sc:Collection".equals(withinType);
            if (skipType) {
                completeness = ModelUtilities.Completeness.ID_ONLY;
            }
        } else if (Objects.equals(containingField, "on") && completeness == ModelUtilities.Completeness.ID_AND_TYPE) {
            boolean skipType;
            boolean bl = skipType = value instanceof Canvas && gen.getCurrentValue() instanceof Annotation && Objects.equals(((Annotation)gen.getCurrentValue()).getMotivation(), Motivation.PAINTING);
            if (skipType) {
                completeness = ModelUtilities.Completeness.ID_ONLY;
            }
        } else {
            boolean shouldSkip;
            ImmutableSet skipParents = ImmutableSet.of((Object)"contentLayer", (Object)"ranges", (Object)"annotations");
            boolean bl = shouldSkip = Arrays.asList("prev", "next", "first", "last").contains(containingField) || completeness == ModelUtilities.Completeness.ID_AND_TYPE && skipParents.contains((Object)containingField) || "otherContent".equals(containingField) && "sc:Layer".equals(parentType);
            if (shouldSkip) {
                completeness = ModelUtilities.Completeness.ID_ONLY;
            }
        }
        switch (completeness) {
            case EMPTY: {
                gen.writeNull();
                break;
            }
            case ID_ONLY: {
                gen.writeString(value.getIdentifier().toString());
                break;
            }
            default: {
                this.defaultSerializer.serialize((Object)value, gen, serializers);
            }
        }
        if (typeBackup != null) {
            ((ImageContent)value)._type = typeBackup;
        }
    }

    private static String getContainingField(JsonGenerator gen) {
        JsonStreamContext ctx = gen.getOutputContext();
        if (ctx.inArray()) {
            return ctx.getParent().getCurrentName();
        }
        return ctx.getCurrentName();
    }
}

