/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.image;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Objects;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.ResolvingException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SizeRequest {
    private static final Pattern PARSE_PAT = Pattern.compile("^(!|pct:)?(?:([0-9]+)?,([0-9]+)?|([0-9.]+))$");
    private boolean max = false;
    private boolean bestFit = false;
    private Integer width = null;
    private Integer height = null;
    private BigDecimal percentage = null;

    @JsonCreator
    public static SizeRequest fromString(String str) throws ResolvingException {
        if (str.equals("full")) {
            return new SizeRequest();
        }
        if (str.equals("max")) {
            return new SizeRequest(true);
        }
        Matcher matcher = PARSE_PAT.matcher(str);
        if (!matcher.matches()) {
            throw new ResolvingException("Bad format: " + str);
        }
        if (matcher.group(1) != null) {
            if (matcher.group(1).equals("!")) {
                return new SizeRequest(Integer.valueOf(matcher.group(2)), Integer.valueOf(matcher.group(3)), true);
            }
            if (matcher.group(1).equals("pct:")) {
                return new SizeRequest(new BigDecimal(matcher.group(4)));
            }
        }
        Integer width = null;
        Integer height = null;
        if (matcher.group(2) != null) {
            width = Integer.parseInt(matcher.group(2));
        }
        if (matcher.group(3) != null) {
            height = Integer.parseInt(matcher.group(3));
        }
        return new SizeRequest(width, height);
    }

    public SizeRequest() {
        this(false);
    }

    public SizeRequest(boolean isMax) {
        this.max = isMax;
    }

    public SizeRequest(Integer width, Integer height) throws ResolvingException {
        if (width == null && height == null) {
            throw new ResolvingException("Either width or height must be specified!");
        }
        this.width = width;
        this.height = height;
    }

    public SizeRequest(int width, int height, boolean bestFit) throws ResolvingException {
        this(width, height);
        this.bestFit = bestFit;
    }

    public SizeRequest(BigDecimal percentage) throws ResolvingException {
        if (percentage.doubleValue() < 0.0 || percentage.doubleValue() > 100.0) {
            throw new ResolvingException("Percentage must be between 0 and 100!");
        }
        this.percentage = percentage;
    }

    public boolean isMax() {
        return this.max;
    }

    public boolean isBestFit() {
        return this.bestFit;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public BigDecimal getPercentage() {
        return this.percentage;
    }

    public String getCanonicalForm(Dimension nativeSize, ImageApiProfile profile) throws ResolvingException {
        Dimension resolved = this.resolve(nativeSize, profile);
        double nativeRatio = nativeSize.getWidth() / nativeSize.getHeight();
        double resolvedRatio = resolved.getWidth() / resolved.getHeight();
        if (resolved.equals(nativeSize)) {
            return "full";
        }
        if (this.width != null && this.height == null) {
            return this.toString();
        }
        if (Math.floor(resolvedRatio * nativeSize.getHeight()) == nativeSize.getWidth() || Math.ceil(resolvedRatio * nativeSize.getHeight()) == nativeSize.getWidth()) {
            return String.format("%d,", resolved.width);
        }
        return String.format("%d,%d", resolved.width, resolved.height);
    }

    public Dimension resolve(Dimension nativeSize, ImageApiProfile profile) throws ResolvingException {
        return this.resolve(nativeSize, Collections.emptyList(), profile);
    }

    public Dimension resolve(Dimension nativeSize, List<Dimension> availableSizes, ImageApiProfile profile) throws ResolvingException {
        Integer maxHeight;
        Dimension out;
        double aspect = (double)nativeSize.width / (double)nativeSize.height;
        if (this.max) {
            long currentArea;
            Dimension dim = availableSizes.stream().filter(s -> s.width <= nativeSize.width && s.height <= nativeSize.height).max(Comparator.comparing(Dimension::getWidth).thenComparing(Dimension::getHeight)).orElse(new Dimension(nativeSize.width, nativeSize.height));
            if (profile != null && profile.maxWidth != null) {
                int maxHeight2;
                if (dim.width > profile.maxWidth) {
                    dim.width = profile.maxWidth;
                    dim.height = (int)((double)profile.maxWidth.intValue() / aspect);
                }
                if (dim.height > (maxHeight2 = (profile.maxHeight != null ? profile.maxHeight : profile.maxWidth).intValue())) {
                    dim.height = maxHeight2;
                    dim.width = (int)(aspect * (double)dim.height);
                }
            }
            if (profile != null && profile.maxArea != null && (currentArea = (long)dim.width * (long)dim.height) > profile.maxArea) {
                dim.width = (int)Math.sqrt(aspect * (double)profile.maxArea.longValue());
                dim.height = (int)((double)dim.width / aspect);
                if (dim.width <= 0 || dim.height <= 0) {
                    throw new ResolvingException(String.format("Cannot fit image with dimensions %dx%d into maximum area of %d pixels.", nativeSize.width, nativeSize.height, profile.maxArea));
                }
            }
            return dim;
        }
        if (this.percentage != null || this.bestFit) {
            double ratio = this.percentage != null ? this.percentage.doubleValue() / 100.0 : Math.min((double)this.width.intValue() / nativeSize.getWidth(), (double)this.height.intValue() / nativeSize.getHeight());
            out = new Dimension((int)(ratio * (double)nativeSize.width), (int)(ratio * (double)nativeSize.height));
        } else if (this.width == null && this.height == null) {
            out = nativeSize;
        } else {
            out = new Dimension();
            if (this.width != null) {
                out.width = this.width;
            }
            if (this.height != null) {
                out.height = this.height;
            }
            if (this.width == null) {
                out.width = (int)((double)out.height * aspect);
            }
            if (this.height == null) {
                out.height = (int)((double)out.width / aspect);
            }
        }
        Integer n = maxHeight = profile.maxHeight != null ? profile.maxHeight : profile.maxWidth;
        if (profile.maxWidth != null && out.width > profile.maxWidth) {
            throw new ResolvingException(String.format("Requested width (%d) exceeds maximum width (%d) as specified in the profile.", out.width, profile.maxWidth));
        }
        if (maxHeight != null && out.height > maxHeight) {
            throw new ResolvingException(String.format("Requested height (%d) exceeds maximum height (%d) as specified in the profile.", out.height, maxHeight));
        }
        if (profile.maxArea != null && (long)(out.height * out.width) > profile.maxArea) {
            throw new ResolvingException(String.format("Requested area (%d*%d = %d) exceeds maximum area (%d) as specified in the profile", out.width, out.height, out.width * out.height, profile.maxArea));
        }
        if (!(profile.features != null && profile.features.contains(ImageApiProfile.Feature.SIZE_ABOVE_FULL) || out.width <= nativeSize.width && out.height <= nativeSize.height)) {
            throw new ResolvingException(String.format("Requested dimensions (%dx%d) exceed native dimensions (%dx%d), profile states that upscaling is not supported.", out.width, out.height, nativeSize.width, nativeSize.height));
        }
        return out;
    }

    public Dimension resolve(Rectangle region, ImageApiProfile profile) throws ResolvingException {
        return this.resolve(new Dimension(region.width, region.height), profile);
    }

    @JsonCreator
    @JsonValue
    public String toString() {
        if (this.width == null && this.height == null && this.percentage == null) {
            return this.max ? "max" : "full";
        }
        if (this.percentage != null) {
            return String.format("pct:%s", this.percentage);
        }
        StringBuilder rv = new StringBuilder();
        if (this.width != null) {
            rv.append(String.valueOf(this.width));
        }
        rv.append(",");
        if (this.height != null) {
            rv.append(String.valueOf(this.height));
        }
        return this.bestFit ? "!" + rv.toString() : rv.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SizeRequest that = (SizeRequest)o;
        return this.max == that.max && this.bestFit == that.bestFit && Objects.equal((Object)this.width, (Object)that.width) && Objects.equal((Object)this.height, (Object)that.height) && Objects.equal((Object)this.percentage, (Object)that.percentage);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.max, this.bestFit, this.width, this.height, this.percentage});
    }
}

