/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.sharedcanvas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.PropertyValue;
import de.digitalcollections.iiif.model.enums.ViewingHint;
import de.digitalcollections.iiif.model.interfaces.PageContainer;
import de.digitalcollections.iiif.model.interfaces.Pageable;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class Collection
extends Resource<Collection>
implements Pageable<Collection>,
PageContainer<Collection> {
    public static final String TYPE = "sc:Collection";
    private OffsetDateTime navDate;
    @JsonProperty(value="first")
    private Collection firstPage;
    @JsonProperty(value="last")
    private Collection lastPage;
    @JsonProperty(value="total")
    private Integer totalPages;
    @JsonProperty(value="next")
    private Collection nextPage;
    @JsonProperty(value="previous")
    private Collection previousPage;
    @JsonProperty(value="startIndex")
    private Integer startIndex;
    private List<Collection> collections;
    private List<Manifest> manifests;
    private List<Resource> members;

    @JsonCreator
    public Collection(@JsonProperty(value="@id") String identifier) {
        super(identifier);
    }

    public Collection(String identifier, String label) {
        super(identifier);
        this.addLabel(label, new String[0]);
    }

    public Collection(URI identifier, PropertyValue label) {
        this.setIdentifier(identifier);
        this.setLabel(label);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @JsonIgnore
    public Set<ViewingHint.Type> getSupportedViewingHintTypes() {
        return ImmutableSet.of((Object)((Object)ViewingHint.Type.TOP), (Object)((Object)ViewingHint.Type.INDIVIDUALS), (Object)((Object)ViewingHint.Type.MULTI_PART));
    }

    public List<Collection> getCollections() {
        return this.collections;
    }

    public void setCollections(List<Collection> collections) {
        this.collections = collections;
    }

    public Collection addCollection(Collection first, Collection ... rest) {
        if (this.collections == null) {
            this.collections = new ArrayList<Collection>();
        }
        this.collections.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public List<Manifest> getManifests() {
        return this.manifests;
    }

    public void setManifests(List<Manifest> manifests) {
        this.manifests = manifests;
    }

    public Collection addManifest(Manifest first, Manifest ... rest) {
        if (this.manifests == null) {
            this.manifests = new ArrayList<Manifest>();
        }
        this.manifests.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public List<Resource> getMembers() {
        return this.members;
    }

    private void checkMember(Resource member) {
        if (member instanceof Collection) {
            Collection coll = (Collection)member;
            if (coll.getViewingHints().isEmpty()) {
                throw new IllegalArgumentException("Collection members must have a viewingHint.");
            }
        } else if (!(member instanceof Manifest)) {
            throw new IllegalArgumentException("Members must be either Manifest or Collection resources.");
        }
    }

    public void setMembers(List<Resource> members) {
        members.forEach(this::checkMember);
        this.members = members;
    }

    public Collection addMember(Resource first, Resource ... rest) {
        if (this.members == null) {
            this.members = new ArrayList<Resource>();
            this.checkMember(first);
            Arrays.stream(rest).forEach(this::checkMember);
        }
        this.members.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public OffsetDateTime getNavDate() {
        return this.navDate;
    }

    public void setNavDate(OffsetDateTime navDate) {
        this.navDate = navDate;
    }

    @Override
    public Collection getFirst() {
        return this.firstPage;
    }

    @Override
    public void setFirst(Collection first) {
        this.firstPage = first;
    }

    @Override
    public Collection getLast() {
        return this.lastPage;
    }

    @Override
    public void setLast(Collection last) {
        this.lastPage = last;
    }

    @Override
    public Integer getTotal() {
        return this.totalPages;
    }

    @Override
    public void setTotal(int total) {
        this.totalPages = total;
    }

    @Override
    public Collection getNext() {
        return this.nextPage;
    }

    @Override
    public void setNext(Collection next) {
        this.nextPage = next;
    }

    @Override
    public Collection getPrevious() {
        return this.previousPage;
    }

    @Override
    public void setPrevious(Collection previous) {
        this.previousPage = previous;
    }

    @Override
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Override
    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }
}

