/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.image;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Objects;
import de.digitalcollections.iiif.model.image.ResolvingException;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RotationRequest {
    private static final Pattern PATTERN = Pattern.compile("^(!)?([0-9]*\\.?[0-9]+)$");
    BigDecimal rotation;
    boolean mirror = false;

    @JsonCreator
    public static RotationRequest fromString(String str) throws ResolvingException {
        Matcher matcher = PATTERN.matcher(str);
        if (!matcher.matches()) {
            throw new ResolvingException("Bad format: " + str);
        }
        return new RotationRequest(new BigDecimal(matcher.group(2)), matcher.group(1) != null);
    }

    public RotationRequest(int rotation) throws ResolvingException {
        this(BigDecimal.valueOf(rotation), false);
    }

    public RotationRequest(BigDecimal rotation, boolean mirror) throws ResolvingException {
        if (rotation.floatValue() < 0.0f || rotation.floatValue() > 360.0f) {
            throw new ResolvingException("Rotation must be between 0 and 360");
        }
        this.rotation = rotation;
        this.mirror = mirror;
    }

    public double getRotation() {
        return this.rotation.doubleValue();
    }

    public boolean isMirror() {
        return this.mirror;
    }

    @JsonValue
    public String toString() {
        String out = this.rotation.toString();
        if (this.mirror) {
            out = "!" + out;
        }
        return out;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RotationRequest that = (RotationRequest)o;
        return this.mirror == that.mirror && Objects.equal((Object)this.rotation, (Object)that.rotation);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rotation, this.mirror});
    }
}

