/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.PropertyValue;
import de.digitalcollections.iiif.model.Service;
import de.digitalcollections.iiif.model.auth.AuthPattern;
import de.digitalcollections.iiif.model.auth.AuthService;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"@context", "@id", "profile", "label", "header", "description", "confirmLabel", "failureHeader", "failureDescription", "service"})
public class AccessCookieService
extends Service {
    public static final String CONTEXT = "http://iiif.io/api/auth/1/context.json";
    @JsonProperty(value="profile")
    private AuthPattern authPattern;
    private PropertyValue confirmLabel;
    private PropertyValue header;
    private PropertyValue description;
    private PropertyValue failureHeader;
    private PropertyValue failureDescription;
    @JsonProperty(value="service")
    private List<AuthService> services;

    @JsonCreator
    public AccessCookieService(@JsonProperty(value="@id") String identifier, @JsonProperty(value="profile") AuthPattern pattern) {
        this(identifier == null ? null : URI.create(identifier), pattern);
    }

    public AccessCookieService(URI identifier, AuthPattern pattern) throws IllegalArgumentException {
        super(URI.create(CONTEXT));
        if (identifier == null && pattern != AuthPattern.EXTERNAL) {
            throw new IllegalArgumentException("Identifier must be present!");
        }
        this.setIdentifier(identifier);
        this.authPattern = pattern;
    }

    public AuthPattern getAuthPattern() {
        return this.authPattern;
    }

    public PropertyValue getConfirmLabel() {
        return this.confirmLabel;
    }

    @JsonIgnore
    public String getConfirmLabelString() {
        return this.confirmLabel.getFirstValue();
    }

    public void setConfirmLabel(PropertyValue confirmLabel) {
        this.confirmLabel = confirmLabel;
    }

    public void setConfirmLabel(String label) {
        this.setConfirmLabel(new PropertyValue(label, new String[0]));
    }

    public PropertyValue getHeader() {
        return this.header;
    }

    @JsonIgnore
    public String getHeaderString() {
        return this.header.getFirstValue();
    }

    public void setHeader(PropertyValue header) {
        this.header = header;
    }

    public void setHeader(String header) {
        this.setHeader(new PropertyValue(header, new String[0]));
    }

    public PropertyValue getDescription() {
        return this.description;
    }

    @JsonIgnore
    public String getDescriptionString() {
        return this.description.getFirstValue();
    }

    public void setDescription(PropertyValue description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.setDescription(new PropertyValue(description, new String[0]));
    }

    public PropertyValue getFailureHeader() {
        return this.failureHeader;
    }

    @JsonIgnore
    public String getFailureHeaderString() {
        return this.failureHeader.getFirstValue();
    }

    public void setFailureHeader(PropertyValue failureHeader) {
        this.failureHeader = failureHeader;
    }

    public void setFailureHeader(String failureHeader) {
        this.setFailureHeader(new PropertyValue(failureHeader, new String[0]));
    }

    public PropertyValue getFailureDescription() {
        return this.failureDescription;
    }

    @JsonIgnore
    public String getFailureDescriptionString() {
        return this.failureDescription.getFirstValue();
    }

    public void setFailureDescription(PropertyValue failureDescription) {
        this.failureDescription = failureDescription;
    }

    public void setFailureDescription(String failureDescription) {
        this.setFailureDescription(new PropertyValue(failureDescription, new String[0]));
    }

    public List<AuthService> getServices() {
        return this.services;
    }

    public void setServices(List<AuthService> services) {
        this.services = services;
    }

    public void addService(AuthService first, AuthService ... rest) {
        if (this.services == null) {
            this.services = new ArrayList<AuthService>();
        }
        this.services.addAll(Lists.asList((Object)first, (Object[])rest));
    }
}

