/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.sharedcanvas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.enums.ViewingDirection;
import de.digitalcollections.iiif.model.enums.ViewingHint;
import de.digitalcollections.iiif.model.sharedcanvas.Range;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import de.digitalcollections.iiif.model.sharedcanvas.Sequence;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@JsonPropertyOrder(value={"@context", "@type", "@id", "label", "metadata", "description", "navDate", "license", "attribution", "service", "seeAlso", "rendering", "within", "sequences", "structures"})
public class Manifest
extends Resource {
    public static final String TYPE = "sc:Manifest";
    private ViewingDirection viewingDirection;
    private OffsetDateTime navDate;
    private List<Sequence> sequences;
    @JsonProperty(value="structures")
    private List<Range> ranges;

    @JsonCreator
    public Manifest(@JsonProperty(value="@id") String identifier) {
        super(identifier);
    }

    public Manifest(String identifier, String label) {
        this(identifier);
        this.addLabel(label, new String[0]);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public ViewingDirection getViewingDirection() {
        return this.viewingDirection;
    }

    public void setViewingDirection(ViewingDirection viewingDirection) {
        this.viewingDirection = viewingDirection;
    }

    @Override
    @JsonIgnore
    public Set<ViewingHint.Type> getSupportedViewingHintTypes() {
        return ImmutableSet.of((Object)((Object)ViewingHint.Type.INDIVIDUALS), (Object)((Object)ViewingHint.Type.PAGED), (Object)((Object)ViewingHint.Type.CONTINUOUS));
    }

    public OffsetDateTime getNavDate() {
        return this.navDate;
    }

    public void setNavDate(OffsetDateTime navDate) {
        this.navDate = navDate;
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public void setSequences(List<Sequence> sequences) {
        this.sequences = sequences;
    }

    @JsonIgnore
    public Sequence getDefaultSequence() {
        if (this.sequences == null || this.sequences.isEmpty()) {
            return null;
        }
        return this.sequences.get(0);
    }

    public Manifest addSequence(Sequence first, Sequence ... rest) {
        if (this.sequences == null) {
            this.sequences = new ArrayList<Sequence>();
        }
        this.sequences.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<Range> ranges) {
        this.ranges = ranges;
    }

    public Manifest addRange(Range first, Range ... rest) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<Range>();
        }
        this.ranges.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }
}

