/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.openannotation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Choice
extends Resource {
    public static final String TYPE = "oa:Choice";
    @JsonProperty(value="default")
    private final Resource defaultResource;
    @JsonProperty(value="item")
    private List<Resource> alternatives;

    @JsonCreator
    public Choice(@JsonProperty(value="default") Resource defaultResource, @JsonProperty(value="item") List<Resource> alternatives) {
        this.defaultResource = defaultResource.getIdentifier().toString().equals("rdf:nil") ? null : defaultResource;
        this.alternatives = alternatives.stream().map(r -> r.getIdentifier().toString().equals("rdf:nil") ? null : r).collect(Collectors.toList());
    }

    public Choice(Resource defaultResource, Resource firstAlternative, Resource ... otherAlternatives) {
        this.defaultResource = defaultResource;
        this.alternatives = new ArrayList<Resource>();
        this.alternatives.addAll(Lists.asList((Object)firstAlternative, (Object[])otherAlternatives));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public Resource getDefault() {
        return this.defaultResource;
    }

    public List<Resource> getAlternatives() {
        return this.alternatives;
    }

    public final void addAlternative(Resource first, Resource ... rest) {
        if (this.alternatives == null) {
            this.alternatives = new ArrayList<Resource>();
        }
        this.alternatives.addAll(Lists.asList((Object)first, (Object[])rest));
    }
}

