/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import de.digitalcollections.iiif.model.ImageContent;
import de.digitalcollections.iiif.model.Motivation;
import de.digitalcollections.iiif.model.OtherContent;
import de.digitalcollections.iiif.model.openannotation.Annotation;
import de.digitalcollections.iiif.model.openannotation.Choice;
import de.digitalcollections.iiif.model.openannotation.ContentAsText;
import de.digitalcollections.iiif.model.openannotation.CssStyle;
import de.digitalcollections.iiif.model.openannotation.SpecificResource;
import de.digitalcollections.iiif.model.sharedcanvas.AnnotationList;
import de.digitalcollections.iiif.model.sharedcanvas.Canvas;
import de.digitalcollections.iiif.model.sharedcanvas.Collection;
import de.digitalcollections.iiif.model.sharedcanvas.Layer;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import de.digitalcollections.iiif.model.sharedcanvas.Range;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import de.digitalcollections.iiif.model.sharedcanvas.Sequence;
import java.io.IOException;

public class ResourceDeserializer
extends JsonDeserializer<Resource> {
    private static final ImmutableMap<String, Class<? extends Resource>> MAPPING = new ImmutableMap.Builder().put((Object)"oa:Annotation", Annotation.class).put((Object)"sc:AnnotationList", AnnotationList.class).put((Object)"sc:Canvas", Canvas.class).put((Object)"sc:Collection", Collection.class).put((Object)"sc:Layer", Layer.class).put((Object)"sc:Manifest", Manifest.class).put((Object)"sc:Range", Range.class).put((Object)"sc:Sequence", Sequence.class).put((Object)"oa:Choice", Choice.class).put((Object)"dctypes:Image", ImageContent.class).put((Object)"oa:SpecificResource", SpecificResource.class).put((Object)"cnt:ContentAsText", ContentAsText.class).put((Object)"oa:CssStyle", CssStyle.class).build();

    public Resource deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        String containingField = ResourceDeserializer.getContainingField(p);
        if (p.getCurrentToken() == JsonToken.START_OBJECT) {
            ObjectNode obj = (ObjectNode)mapper.readTree(p);
            JsonNode typeNode = obj.get("@type");
            String typeName = typeNode.isMissingNode() ? this.getMissingType(ctxt, containingField) : typeNode.textValue();
            return (Resource)mapper.treeToValue((TreeNode)obj, (Class)MAPPING.getOrDefault((Object)typeName, OtherContent.class));
        }
        if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
            String stringValue = p.getValueAsString();
            String typeName = this.getMissingType(ctxt, containingField);
            return this.resourceFromString((Class)MAPPING.getOrDefault((Object)typeName, OtherContent.class), stringValue);
        }
        if (p.getCurrentToken() == JsonToken.START_ARRAY) {
            ArrayNode arr = (ArrayNode)mapper.readTree(p);
            throw new RuntimeException("Could not deserialize Resource.");
        }
        throw new RuntimeException("Could not deserialize Resource.");
    }

    private String getMissingType(DeserializationContext ctxt, String containingField) {
        switch (containingField) {
            case "on": {
                return this.getOnType(ctxt);
            }
            case "within": {
                return this.getWithinType(ctxt);
            }
            case "canvases": {
                return "sc:Canvas";
            }
            case "thumbnail": 
            case "logo": {
                return "dctypes:Image";
            }
        }
        return null;
    }

    private String getWithinType(DeserializationContext ctxt) {
        Resource obj = (Resource)ctxt.getParser().getCurrentValue();
        if (obj instanceof Manifest || obj instanceof Collection) {
            return "sc:Collection";
        }
        if (obj instanceof AnnotationList) {
            return "sc:Layer";
        }
        return null;
    }

    private String getOnType(DeserializationContext ctxt) {
        JsonStreamContext parent;
        boolean isPaintingAnno;
        Object curVal = ctxt.getParser().getCurrentValue();
        boolean bl = isPaintingAnno = curVal != null && curVal instanceof Annotation && ((Annotation)curVal).getMotivation() != null && ((Annotation)curVal).getMotivation().equals(Motivation.PAINTING);
        if (isPaintingAnno) {
            return "sc:Canvas";
        }
        for (parent = ctxt.getParser().getParsingContext().getParent(); !(parent == null || parent.getCurrentValue() != null && parent.getCurrentValue() instanceof Resource); parent = parent.getParent()) {
        }
        if (parent != null) {
            Resource parentObj = (Resource)parent.getCurrentValue();
            return parentObj.getType();
        }
        return null;
    }

    private Resource resourceFromString(Class<? extends Resource> clz, String resourceString) {
        try {
            return clz.getConstructor(String.class).newInstance(resourceString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not construct %s from '%s'", clz.getName(), resourceString));
        }
    }

    private static String getContainingField(JsonParser parser) {
        JsonStreamContext ctx = parser.getParsingContext();
        if (ctx.inArray()) {
            return ctx.getParent().getCurrentName();
        }
        return ctx.getCurrentName();
    }
}

