/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.Service;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.jackson.serialization.EnumDeserializer;
import de.digitalcollections.iiif.model.jackson.serialization.ProfileDeserializer;
import de.digitalcollections.iiif.model.jackson.serialization.ResourceDeserializer;
import de.digitalcollections.iiif.model.jackson.serialization.ServiceDeserializer;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.util.Arrays;

public class DeserializerModifier
extends BeanDeserializerModifier {
    public JsonDeserializer<?> modifyEnumDeserializer(DeserializationConfig config, JavaType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        if (Arrays.asList(ImageApiProfile.Quality.class, ImageApiProfile.Format.class).contains(type.getRawClass())) {
            return new EnumDeserializer(type.getRawClass());
        }
        return super.modifyEnumDeserializer(config, type, beanDesc, deserializer);
    }

    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        if (Service.class == beanDesc.getBeanClass()) {
            return new ServiceDeserializer();
        }
        if (Resource.class == beanDesc.getBeanClass()) {
            return new ResourceDeserializer();
        }
        if (Profile.class == beanDesc.getBeanClass()) {
            return new ProfileDeserializer(deserializer);
        }
        return super.modifyDeserializer(config, beanDesc, deserializer);
    }
}

