/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.sharedcanvas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.ImageContent;
import de.digitalcollections.iiif.model.MetadataEntry;
import de.digitalcollections.iiif.model.OtherContent;
import de.digitalcollections.iiif.model.PropertyValue;
import de.digitalcollections.iiif.model.Service;
import de.digitalcollections.iiif.model.enums.ViewingHint;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@JsonPropertyOrder(value={"@context", "@id", "@type", "label", "description", "metadata", "thumbnail", "service"})
public abstract class Resource {
    public static final String CONTEXT = "http://iiif.io/api/presentation/2/context.json";
    @JsonProperty(value="@context")
    public String _context;
    @JsonProperty(value="@id")
    private URI identifier;
    private PropertyValue label;
    private PropertyValue description;
    @JsonProperty(value="service")
    private List<Service> services;
    @JsonProperty(value="thumbnail")
    private List<ImageContent> thumbnails;
    @JsonProperty(value="attribution")
    private PropertyValue attribution;
    @JsonProperty(value="license")
    private List<URI> licenses;
    @JsonProperty(value="logo")
    private List<ImageContent> logos;
    private List<MetadataEntry> metadata;
    @JsonProperty(value="viewingHint")
    private List<ViewingHint> viewingHints;
    @JsonProperty(value="related")
    private List<OtherContent> related;
    @JsonProperty(value="rendering")
    private List<OtherContent> renderings;
    @JsonProperty(value="seeAlso")
    private List<OtherContent> seeAlsoContents;
    @JsonProperty(value="within")
    private List<Resource> within;

    public Resource() {
        this.identifier = null;
    }

    @JsonCreator
    public Resource(@JsonProperty(value="@id") String identifier) {
        this.identifier = identifier != null ? URI.create(identifier) : null;
    }

    @JsonProperty(value="@type")
    public String getType() {
        return null;
    }

    public URI getIdentifier() {
        return this.identifier;
    }

    protected void setIdentifier(URI identifier) {
        this.identifier = identifier;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public Resource addService(Service first, Service ... rest) {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        this.services.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public List<ImageContent> getThumbnails() {
        return this.thumbnails;
    }

    @JsonIgnore
    public ImageContent getThumbnail() {
        if (this.thumbnails == null || this.thumbnails.isEmpty()) {
            return null;
        }
        return this.thumbnails.get(0);
    }

    public void setThumbnails(List<ImageContent> thumbnails) {
        this.thumbnails = thumbnails;
    }

    public Resource addThumbnail(ImageContent ... thumbnails) {
        if (this.thumbnails == null) {
            this.thumbnails = new ArrayList<ImageContent>();
        }
        this.thumbnails.addAll(Arrays.asList(thumbnails));
        return this;
    }

    public List<MetadataEntry> getMetadata() {
        return this.metadata;
    }

    public Resource addMetadata(MetadataEntry ... meta) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<MetadataEntry>();
        }
        this.metadata.addAll(Arrays.asList(meta));
        return this;
    }

    public Resource addMetadata(String label, String value) {
        return this.addMetadata(new MetadataEntry(label, value));
    }

    public PropertyValue getLabel() {
        return this.label;
    }

    @JsonIgnore
    public String getLabelString() {
        return this.label.getFirstValue();
    }

    public void setLabel(PropertyValue label) {
        this.label = label;
    }

    public Resource addLabel(String first, String ... rest) {
        if (this.label == null) {
            this.label = new PropertyValue();
        }
        this.label.addValue(first, rest);
        return this;
    }

    public PropertyValue getDescription() {
        return this.description;
    }

    @JsonIgnore
    public String getDescriptionString() {
        return this.description.getFirstValue();
    }

    public void setDescription(PropertyValue description) {
        this.description = description;
    }

    public Resource addDescription(String first, String ... rest) {
        if (this.description == null) {
            this.description = new PropertyValue();
        }
        this.description.addValue(first, rest);
        return this;
    }

    public PropertyValue getAttribution() {
        return this.attribution;
    }

    @JsonIgnore
    public String getAttributionString() {
        return this.attribution.getFirstValue();
    }

    public void setAttribution(PropertyValue attribution) {
        this.attribution = attribution;
    }

    public Resource addAttribution(String first, String ... rest) {
        if (this.attribution == null) {
            this.attribution = new PropertyValue();
        }
        this.attribution.addValue(first, rest);
        return this;
    }

    public List<URI> getLicenses() {
        return this.licenses;
    }

    @JsonIgnore
    public URI getFirstLicense() {
        if (this.licenses == null || this.licenses.isEmpty()) {
            return null;
        }
        return this.licenses.get(0);
    }

    public void setLicenses(List<URI> licenses) {
        this.licenses = licenses;
    }

    public Resource addLicense(String first, String ... rest) {
        if (this.licenses == null) {
            this.licenses = new ArrayList<URI>();
        }
        this.licenses.add(URI.create(first));
        Arrays.stream(rest).map(URI::create).forEach(this.licenses::add);
        return this;
    }

    public List<ImageContent> getLogos() {
        return this.logos;
    }

    @JsonIgnore
    public URI getLogoUri() {
        if (this.logos == null || this.logos.isEmpty()) {
            return null;
        }
        return this.logos.get(0).getIdentifier();
    }

    public void setLogos(List<ImageContent> logos) {
        this.logos = logos;
    }

    public Resource addLogo(String first, String ... rest) {
        if (this.logos == null) {
            this.logos = new ArrayList<ImageContent>();
        }
        this.logos.add(new ImageContent(first));
        Arrays.stream(rest).map(ImageContent::new).forEach(this.logos::add);
        return this;
    }

    public Resource addLogo(ImageContent first, ImageContent ... rest) {
        if (this.logos == null) {
            this.logos = new ArrayList<ImageContent>();
        }
        this.logos.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    @JsonIgnore
    public Set<ViewingHint.Type> getSupportedViewingHintTypes() {
        return ImmutableSet.of();
    }

    public List<ViewingHint> getViewingHints() {
        return this.viewingHints;
    }

    public void setViewingHints(List<ViewingHint> viewingHints) throws IllegalArgumentException {
        for (ViewingHint hint : viewingHints) {
            boolean supportsHint = hint.getType() == ViewingHint.Type.OTHER || this.getSupportedViewingHintTypes().contains((Object)hint.getType());
            if (supportsHint) continue;
            throw new IllegalArgumentException(String.format("Resources of type '%s' do not support the '%s' viewing hint.", this.getType(), hint.toString()));
        }
        this.viewingHints = viewingHints;
    }

    public Resource addViewingHint(ViewingHint first, ViewingHint ... rest) throws IllegalArgumentException {
        List<ViewingHint> hints = this.viewingHints;
        if (hints == null) {
            hints = new ArrayList<ViewingHint>();
        }
        hints.addAll(Lists.asList((Object)first, (Object[])rest));
        this.setViewingHints(hints);
        return this;
    }

    public List<OtherContent> getRelated() {
        return this.related;
    }

    public void setRelated(List<OtherContent> related) {
        this.related = related;
    }

    public Resource addRelated(OtherContent first, OtherContent ... rest) {
        if (this.related == null) {
            this.related = new ArrayList<OtherContent>();
        }
        this.related.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public List<OtherContent> getRenderings() {
        return this.renderings;
    }

    public void setRenderings(List<OtherContent> renderings) throws IllegalArgumentException {
        renderings.forEach(this::verifyRendering);
        this.renderings = renderings;
    }

    public Resource addRendering(OtherContent first, OtherContent ... rest) {
        if (this.renderings == null) {
            this.renderings = new ArrayList<OtherContent>();
        }
        List renderings = Lists.asList((Object)first, (Object[])rest);
        renderings.forEach(this::verifyRendering);
        this.renderings.addAll(renderings);
        return this;
    }

    public void verifyRendering(OtherContent content) {
        if (content.getLabel() == null || content.getFormat() == null) {
            throw new IllegalArgumentException("Rendering resources must have a label and format set.");
        }
    }

    public List<OtherContent> getSeeAlso() {
        return this.seeAlsoContents;
    }

    public void setSeeAlso(List<OtherContent> seeAlso) {
        this.seeAlsoContents = seeAlso;
    }

    public Resource addSeeAlso(OtherContent first, OtherContent ... rest) {
        if (this.seeAlsoContents == null) {
            this.seeAlsoContents = new ArrayList<OtherContent>();
        }
        this.seeAlsoContents.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public List<Resource> getWithin() {
        return this.within;
    }

    public void setWithin(List<Resource> within) {
        this.within = within;
    }

    public Resource addWithin(Resource first, Resource ... rest) {
        if (this.within == null) {
            this.within = new ArrayList<Resource>();
        }
        this.within.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public String toString() {
        return String.format("Resource(type='%s',id='%s')", this.getType(), this.getIdentifier());
    }
}

