/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.sharedcanvas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.digitalcollections.core.model.api.MimeType;
import de.digitalcollections.iiif.model.ImageContent;
import de.digitalcollections.iiif.model.Motivation;
import de.digitalcollections.iiif.model.Service;
import de.digitalcollections.iiif.model.enums.ViewingHint;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.ImageService;
import de.digitalcollections.iiif.model.openannotation.Annotation;
import de.digitalcollections.iiif.model.openannotation.Choice;
import de.digitalcollections.iiif.model.sharedcanvas.AnnotationList;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Canvas
extends Resource {
    public static final String TYPE = "sc:Canvas";
    private List<Annotation> images;
    private List<AnnotationList> otherContent;
    private Integer width;
    private Integer height;

    @JsonCreator
    public Canvas(@JsonProperty(value="@id") String identifier) {
        super(identifier);
    }

    public Canvas(String identifier, String label) {
        super(identifier);
        this.addLabel(label, new String[0]);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public List<Annotation> getImages() {
        return this.images;
    }

    private boolean isValidResource(Resource res) {
        if (res instanceof ImageContent) {
            return true;
        }
        if (res instanceof Choice) {
            Choice choice = (Choice)res;
            return this.isValidResource(choice.getDefault()) && choice.getAlternatives().stream().allMatch(this::isValidResource);
        }
        return false;
    }

    public void setImages(List<Annotation> images) throws IllegalArgumentException {
        if (!images.stream().allMatch(a -> this.isValidResource(a.getResource()))) {
            throw new IllegalArgumentException("All annotations must **only** have ImageContent resources. Use otherContent for other types of content.");
        }
        this.images = images;
    }

    public Canvas addIIIFImage(String serviceUrl, ImageApiProfile profile) {
        if (this.images == null) {
            this.images = new ArrayList<Annotation>();
        }
        Annotation imgAnno = new Annotation(Motivation.PAINTING);
        imgAnno.setOn(new Canvas(this.getIdentifier().toString()));
        ImageContent imgRes = new ImageContent(String.format("%s/full/full/0/default.jpg", serviceUrl));
        imgRes.setFormat(MimeType.MIME_IMAGE_JPEG);
        imgRes.setWidth(this.width);
        imgRes.setHeight(this.height);
        imgRes.addService(new ImageService(serviceUrl, profile), new Service[0]);
        imgAnno.setResource(imgRes);
        this.images.add(imgAnno);
        return this;
    }

    private Annotation wrapImageInAnnotation(ImageContent img) {
        Annotation imgAnno = new Annotation(Motivation.PAINTING);
        imgAnno.setOn(new Canvas(this.getIdentifier().toString()));
        imgAnno.setResource(img);
        return imgAnno;
    }

    public Canvas addImage(ImageContent first, ImageContent ... rest) {
        if (this.images == null) {
            this.images = new ArrayList<Annotation>();
        }
        this.images.add(this.wrapImageInAnnotation(first));
        this.images.addAll(Arrays.stream(rest).map(this::wrapImageInAnnotation).collect(Collectors.toList()));
        if (this.images.size() == 1 && this.getWidth() == null && this.getHeight() == null) {
            this.setWidthFromImage(this.images.get(0));
        }
        return this;
    }

    public void setWidthFromImage(Annotation imageAnno) {
        this.setWidth(((ImageContent)imageAnno.getResource()).getWidth());
        this.setHeight(((ImageContent)imageAnno.getResource()).getHeight());
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public List<AnnotationList> getOtherContent() {
        return this.otherContent;
    }

    public void setOtherContent(List<AnnotationList> otherContent) {
        this.otherContent = otherContent;
    }

    public Canvas addOtherContent(AnnotationList first, AnnotationList ... rest) {
        if (this.otherContent == null) {
            this.otherContent = new ArrayList<AnnotationList>();
        }
        this.otherContent.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    @Override
    @JsonIgnore
    public Set<ViewingHint.Type> getSupportedViewingHintTypes() {
        return ImmutableSet.of((Object)((Object)ViewingHint.Type.NON_PAGED), (Object)((Object)ViewingHint.Type.FACING_PAGES));
    }
}

