/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.sharedcanvas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.interfaces.Pageable;
import de.digitalcollections.iiif.model.openannotation.Annotation;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.util.ArrayList;
import java.util.List;

public class AnnotationList
extends Resource
implements Pageable<AnnotationList> {
    public static final String TYPE = "sc:AnnotationList";
    private List<Annotation> resources;
    @JsonProperty(value="next")
    private AnnotationList nextPage;
    @JsonProperty(value="prev")
    private AnnotationList previousPage;
    private Integer startIndex;

    @JsonCreator
    public AnnotationList(@JsonProperty(value="@id") String identifier) {
        super(identifier);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public List<Annotation> getResources() {
        return this.resources;
    }

    public void setResources(List<Annotation> resources) {
        this.resources = resources;
    }

    public AnnotationList addResource(Annotation first, Annotation ... rest) {
        if (this.resources == null) {
            this.resources = new ArrayList<Annotation>();
        }
        this.resources.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    @Override
    public AnnotationList getNext() {
        return this.nextPage;
    }

    @Override
    public void setNext(AnnotationList next) {
        this.nextPage = next;
    }

    @Override
    public AnnotationList getPrevious() {
        return this.previousPage;
    }

    @Override
    public void setPrevious(AnnotationList previous) {
        this.previousPage = previous;
    }

    @Override
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Override
    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }
}

