/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.search.SearchHit;
import de.digitalcollections.iiif.model.search.SearchLayer;
import de.digitalcollections.iiif.model.sharedcanvas.AnnotationList;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SearchResult
extends AnnotationList {
    public static final String CONTEXT = "http://iiif.io/api/search/1/context.json";
    private List<SearchHit> hits;

    @JsonCreator
    public SearchResult(@JsonProperty(value="@id") String identifier) {
        super(identifier);
    }

    @JsonProperty(value="@context")
    public List<String> getContext() {
        return Arrays.asList("http://iiif.io/api/presentation/2/context.json", CONTEXT);
    }

    private void setContext(List<String> contexts) {
    }

    public List<SearchHit> getHits() {
        return this.hits;
    }

    public void setHits(List<SearchHit> hits) {
        this.hits = hits;
    }

    public SearchResult addHit(SearchHit first, SearchHit ... rest) {
        if (this.hits == null) {
            this.hits = new ArrayList<SearchHit>();
        }
        this.hits.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    @Override
    @JsonDeserialize(contentAs=SearchLayer.class)
    public void setWithin(List<Resource> within) throws IllegalArgumentException {
        if (within.stream().anyMatch(r -> !(r instanceof SearchLayer))) {
            throw new IllegalArgumentException("SearchResult can only be within a SearchLayer.");
        }
        super.setWithin(within);
    }

    @Override
    public Resource addWithin(Resource first, Resource ... rest) throws IllegalArgumentException {
        if (!(first instanceof SearchLayer) || Arrays.stream(rest).anyMatch(r -> !(r instanceof SearchLayer))) {
            throw new IllegalArgumentException("SearchResult can only be within a SearchLayer.");
        }
        return super.addWithin(first, rest);
    }

    @Override
    public SearchResult getNext() {
        return (SearchResult)super.getNext();
    }

    @Override
    public void setNext(SearchResult next) {
        super.setNext(next);
    }

    @Override
    public SearchResult getPrevious() {
        return (SearchResult)super.getPrevious();
    }

    @Override
    public void setPrevious(SearchResult previous) {
        super.setPrevious(previous);
    }
}

