/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableMap;
import de.digitalcollections.iiif.model.image.ImageApiSelector;
import de.digitalcollections.iiif.model.interfaces.Selector;
import de.digitalcollections.iiif.model.openannotation.SvgSelector;
import de.digitalcollections.iiif.model.search.TextQuoteSelector;
import java.io.IOException;
import java.util.Map;
import java.util.stream.StreamSupport;

public class SelectorDeserializer
extends JsonDeserializer<Selector> {
    private static final Map<String, Class<? extends Selector>> MAPPING = new ImmutableMap.Builder().put((Object)"iiif:ImageApiSelector", ImageApiSelector.class).put((Object)"oa:SvgSelector", SvgSelector.class).put((Object)"oa:TextQuoteSelector", TextQuoteSelector.class).build();

    public Selector deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String typeName;
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        ObjectNode obj = (ObjectNode)mapper.readTree(p);
        if (obj.get("@type").isArray()) {
            typeName = StreamSupport.stream(obj.get("@type").spliterator(), false).filter(v -> !v.textValue().equals("cnt:ContentAsText")).findFirst().orElse((JsonNode)new TextNode("UNKNOWN")).textValue();
            obj.set("@type", (JsonNode)new TextNode(typeName));
        } else {
            typeName = obj.get("@type").textValue();
        }
        if (MAPPING.containsKey(typeName)) {
            return (Selector)mapper.treeToValue((TreeNode)obj, MAPPING.get(typeName));
        }
        throw new IllegalArgumentException("Cannot deserialize Selector.");
    }
}

