/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.digitalcollections.iiif.model.PropertyValue;
import java.io.IOException;
import java.util.Locale;
import java.util.stream.StreamSupport;

public class PropertyValueDeserializer
extends JsonDeserializer<PropertyValue> {
    public PropertyValue deserialize(JsonParser jp, DeserializationContext dc) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        TreeNode node = mapper.readTree(jp);
        if (TextNode.class.isAssignableFrom(node.getClass())) {
            return new PropertyValue(((TextNode)node).textValue(), new String[0]);
        }
        if (ObjectNode.class.isAssignableFrom(node.getClass())) {
            String language = ((TextNode)node.get("@language")).textValue();
            String value = ((TextNode)node.get("@value")).textValue();
            return new PropertyValue(Locale.forLanguageTag(language), value, new String[0]);
        }
        if (ArrayNode.class.isAssignableFrom(node.getClass())) {
            ArrayNode arr = (ArrayNode)node;
            PropertyValue propVal = new PropertyValue();
            for (int i = 0; i < arr.size(); ++i) {
                if (ObjectNode.class.isAssignableFrom(arr.get(i).getClass())) {
                    ObjectNode curObj = (ObjectNode)arr.get(i);
                    Locale lang = Locale.forLanguageTag(curObj.get("@language").textValue());
                    JsonNode valueNode = curObj.get("@value");
                    if (TextNode.class.isAssignableFrom(valueNode.getClass())) {
                        propVal.addValue(lang, curObj.get("@value").textValue(), new String[0]);
                        continue;
                    }
                    if (!(valueNode instanceof ArrayNode)) continue;
                    StreamSupport.stream(((ArrayNode)valueNode).spliterator(), false).map(JsonNode::textValue).forEach(v -> propVal.addValue(lang, (String)v, new String[0]));
                    continue;
                }
                if (!TextNode.class.isAssignableFrom(arr.get(i).getClass())) continue;
                propVal.addValue(arr.get(i).asText(), new String[0]);
            }
            return propVal;
        }
        throw new IllegalArgumentException("Property values must be strings, objects or arrays");
    }
}

