/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import java.io.IOException;
import java.net.URI;
import java.util.stream.Stream;

public class ProfileDeserializer
extends JsonDeserializer<Profile> {
    private final JsonDeserializer<Object> defaultDeserializer;

    public ProfileDeserializer(JsonDeserializer<Object> defaultDeserializer) {
        this.defaultDeserializer = defaultDeserializer;
    }

    private boolean isImageApiProfile(String profile) {
        return Stream.of(ImageApiProfile.LEVEL_ZERO, ImageApiProfile.LEVEL_ONE, ImageApiProfile.LEVEL_TWO).map(p -> p.getIdentifier().toString()).anyMatch(profile::equals) || ImageApiProfile.V1_PROFILES.contains(profile);
    }

    public Profile deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
            if (this.isImageApiProfile(p.getValueAsString())) {
                return new ImageApiProfile(p.getValueAsString());
            }
            return new Profile(URI.create(p.getValueAsString()));
        }
        if (p.getCurrentToken() == JsonToken.START_OBJECT) {
            return (Profile)p.getCodec().readValue(p, ImageApiProfile.class);
        }
        return (Profile)this.defaultDeserializer.deserialize(p, ctxt);
    }
}

