/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.image;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Objects;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SizeRequest {
    private static final Pattern PARSE_PAT = Pattern.compile("^(!|pct:)?(?:([0-9]+)?,([0-9]+)?|([0-9.]+))$");
    private boolean max = false;
    private boolean bestFit = false;
    private Integer width = null;
    private Integer height = null;
    private BigDecimal percentage = null;

    @JsonCreator
    public static SizeRequest fromString(String str) throws IllegalArgumentException {
        if (str.equals("full")) {
            return new SizeRequest();
        }
        if (str.equals("max")) {
            return new SizeRequest(true);
        }
        Matcher matcher = PARSE_PAT.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Bad format: " + str);
        }
        if (matcher.group(1) != null) {
            if (matcher.group(1).equals("!")) {
                return new SizeRequest(Integer.valueOf(matcher.group(2)), Integer.valueOf(matcher.group(3)), true);
            }
            if (matcher.group(1).equals("pct:")) {
                return new SizeRequest(new BigDecimal(matcher.group(4)));
            }
        }
        Integer width = null;
        Integer height = null;
        if (matcher.group(2) != null) {
            width = Integer.parseInt(matcher.group(2));
        }
        if (matcher.group(3) != null) {
            height = Integer.parseInt(matcher.group(3));
        }
        return new SizeRequest(width, height);
    }

    public SizeRequest() {
        this(false);
    }

    public SizeRequest(boolean isMax) {
        this.max = isMax;
    }

    public SizeRequest(Integer width, Integer height) throws IllegalArgumentException {
        if (width == null && height == null) {
            throw new IllegalArgumentException("Either width or height must be specified!");
        }
        this.width = width;
        this.height = height;
    }

    public SizeRequest(int width, int height, boolean bestFit) {
        this(width, height);
        this.bestFit = bestFit;
    }

    public SizeRequest(BigDecimal percentage) throws IllegalArgumentException {
        if (percentage.doubleValue() < 0.0 || percentage.doubleValue() > 100.0) {
            throw new IllegalArgumentException("Percentage must be between 0 and 100!");
        }
        this.percentage = percentage;
    }

    public boolean isMax() {
        return this.max;
    }

    public boolean isBestFit() {
        return this.bestFit;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public BigDecimal getPercentage() {
        return this.percentage;
    }

    public String getCanonicalForm(Dimension nativeSize, ImageApiProfile profile) {
        Dimension resolved = this.resolve(nativeSize, profile);
        double nativeRatio = nativeSize.getWidth() / nativeSize.getHeight();
        double resolvedRatio = resolved.getWidth() / resolved.getHeight();
        if (resolved.equals(nativeSize)) {
            return "full";
        }
        if (this.width != null && this.height == null) {
            return this.toString();
        }
        if ((double)Math.round(resolvedRatio * nativeSize.getHeight()) == nativeSize.getWidth()) {
            return String.format("%d,", resolved.width);
        }
        return String.format("%d,%d", resolved.width, resolved.height);
    }

    public Dimension resolve(Dimension nativeSize, ImageApiProfile profile) {
        double aspect = (double)nativeSize.width / (double)nativeSize.height;
        if (this.max) {
            int currentArea;
            Dimension dim = new Dimension(nativeSize);
            if (profile != null && profile.maxWidth != null) {
                dim.width = profile.maxWidth;
                dim.height = (int)(aspect * (double)profile.maxWidth.intValue());
                if (profile.maxHeight != null && profile.maxHeight != null && dim.height > profile.maxHeight) {
                    dim.height = profile.maxHeight;
                    dim.width = (int)(aspect * (double)dim.height);
                } else {
                    dim.height = (int)((double)dim.width / aspect);
                }
            }
            if (profile != null && profile.maxArea != null && (currentArea = dim.width * dim.height) > profile.maxArea) {
                dim.width = (int)Math.sqrt(aspect / (double)profile.maxArea.intValue());
                dim.height = (int)((double)dim.width / aspect);
            }
            return dim;
        }
        if (this.percentage != null || this.bestFit) {
            double ratio = this.percentage != null ? this.percentage.doubleValue() / 100.0 : Math.min((double)this.width.intValue() / nativeSize.getWidth(), (double)this.height.intValue() / nativeSize.getHeight());
            return new Dimension((int)(ratio * (double)nativeSize.width), (int)(ratio * (double)nativeSize.height));
        }
        if (this.width == null && this.height == null) {
            return nativeSize;
        }
        Dimension out = new Dimension();
        if (this.width != null) {
            out.width = this.width;
        }
        if (this.height != null) {
            out.height = this.height;
        }
        if (this.width == null) {
            out.width = (int)((double)out.height * aspect);
        }
        if (this.height == null) {
            out.height = (int)((double)out.width / aspect);
        }
        return out;
    }

    public Dimension resolve(Rectangle region, ImageApiProfile profile) {
        return this.resolve(new Dimension(region.width, region.height), profile);
    }

    @JsonCreator
    @JsonValue
    public String toString() {
        if (this.width == null && this.height == null && this.percentage == null) {
            return this.max ? "max" : "full";
        }
        if (this.percentage != null) {
            return String.format("pct:%s", this.percentage);
        }
        StringBuilder rv = new StringBuilder();
        if (this.width != null) {
            rv.append(String.valueOf(this.width));
        }
        rv.append(",");
        if (this.height != null) {
            rv.append(String.valueOf(this.height));
        }
        return this.bestFit ? "!" + rv.toString() : rv.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SizeRequest that = (SizeRequest)o;
        return this.max == that.max && this.bestFit == that.bestFit && Objects.equal((Object)this.width, (Object)that.width) && Objects.equal((Object)this.height, (Object)that.height) && Objects.equal((Object)this.percentage, (Object)that.percentage);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.max, this.bestFit, this.width, this.height, this.percentage});
    }
}

