/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.image;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Objects;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class RegionRequest {
    private Rectangle absoluteBox;
    private RelativeBox relativeBox;
    private boolean square = false;
    private static final Pattern parsePat = Pattern.compile("^(pct:)?([0-9.]+),([0-9.]+),([0-9.]+),([0-9.]+)$");

    @JsonCreator
    public static RegionRequest fromString(String str) throws IllegalArgumentException {
        if (str.equals("full")) {
            return new RegionRequest();
        }
        if (str.equals("square")) {
            return new RegionRequest(true);
        }
        Matcher matcher = parsePat.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Bad format: " + str);
        }
        if (matcher.group(1) == null) {
            return new RegionRequest(Integer.valueOf(matcher.group(2)), Integer.valueOf(matcher.group(3)), Integer.valueOf(matcher.group(4)), Integer.valueOf(matcher.group(5)));
        }
        return new RegionRequest(new BigDecimal(matcher.group(2)), new BigDecimal(matcher.group(3)), new BigDecimal(matcher.group(4)), new BigDecimal(matcher.group(5)));
    }

    public RegionRequest() {
        this(false);
    }

    public RegionRequest(boolean square) {
        this.square = square;
    }

    private RegionRequest(BigDecimal x, BigDecimal y, BigDecimal width, BigDecimal height) throws IllegalArgumentException {
        if (Stream.of(x, y, width, height).anyMatch(v -> v.doubleValue() > 100.0)) {
            throw new IllegalArgumentException("No parameter can be greater than 100!");
        }
        this.relativeBox = new RelativeBox(x, y, width, height);
    }

    public RegionRequest(double x, double y, double width, double height) throws IllegalArgumentException {
        this(BigDecimal.valueOf(x), BigDecimal.valueOf(y), BigDecimal.valueOf(width), BigDecimal.valueOf(height));
    }

    public RegionRequest(int x, int y, int width, int height) {
        this.absoluteBox = new Rectangle(x, y, width, height);
    }

    public Rectangle2D getRegion() {
        if (this.isRelative()) {
            return new Rectangle2D.Double(this.relativeBox.x.doubleValue(), this.relativeBox.y.doubleValue(), this.relativeBox.w.doubleValue(), this.relativeBox.h.doubleValue());
        }
        return this.absoluteBox;
    }

    public boolean isRelative() {
        return this.relativeBox != null;
    }

    public boolean isSquare() {
        return this.square;
    }

    @JsonValue
    public String toString() {
        if (this.square) {
            return "square";
        }
        if (this.relativeBox == null && this.absoluteBox == null) {
            return "full";
        }
        if (this.isRelative()) {
            return String.format("pct:%s,%s,%s,%s", this.relativeBox.x, this.relativeBox.y, this.relativeBox.w, this.relativeBox.h);
        }
        return String.format("%d,%d,%d,%d", this.absoluteBox.x, this.absoluteBox.y, this.absoluteBox.width, this.absoluteBox.height);
    }

    public String getCanonicalForm(Dimension imageDims) {
        boolean isFull;
        Rectangle resolved = this.resolve(imageDims);
        boolean bl = isFull = resolved.x == 0 && resolved.y == 0 && resolved.width == imageDims.width && resolved.height == imageDims.height;
        if (isFull) {
            return "full";
        }
        return String.format("%d,%d,%d,%d", resolved.x, resolved.y, resolved.width, resolved.height);
    }

    public Rectangle resolve(Dimension imageDims) {
        if (this.square) {
            if (imageDims.width > imageDims.height) {
                return new Rectangle((imageDims.width - imageDims.height) / 2, 0, imageDims.height, imageDims.height);
            }
            if (imageDims.height > imageDims.width) {
                return new Rectangle(0, (imageDims.height - imageDims.width) / 2, imageDims.width, imageDims.width);
            }
        }
        if (this.absoluteBox == null && this.relativeBox == null) {
            return new Rectangle(0, 0, imageDims.width, imageDims.height);
        }
        Rectangle rect = this.isRelative() ? new Rectangle((int)Math.round(this.relativeBox.x.doubleValue() / 100.0 * imageDims.getWidth()), (int)Math.round(this.relativeBox.y.doubleValue() / 100.0 * imageDims.getHeight()), (int)Math.round(this.relativeBox.w.doubleValue() / 100.0 * imageDims.getWidth()), (int)Math.round(this.relativeBox.h.doubleValue() / 100.0 * imageDims.getHeight())) : this.absoluteBox;
        if (rect.x + rect.width > imageDims.width) {
            rect.width = imageDims.width - rect.x;
        }
        if (rect.y + rect.height > imageDims.height) {
            rect.height = imageDims.height - rect.y;
        }
        return rect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionRequest that = (RegionRequest)o;
        return this.square == that.square && Objects.equal((Object)this.absoluteBox, (Object)that.absoluteBox) && Objects.equal((Object)this.relativeBox, (Object)that.relativeBox);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.absoluteBox, this.relativeBox, this.square});
    }

    private class RelativeBox {
        final BigDecimal x;
        final BigDecimal y;
        final BigDecimal w;
        final BigDecimal h;

        public RelativeBox(BigDecimal x, BigDecimal y, BigDecimal w, BigDecimal h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelativeBox that = (RelativeBox)o;
            return Objects.equal((Object)this.x, (Object)that.x) && Objects.equal((Object)this.y, (Object)that.y) && Objects.equal((Object)this.w, (Object)that.w) && Objects.equal((Object)this.h, (Object)that.h);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.x, this.y, this.w, this.h});
        }
    }
}

