/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.image;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableSet;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.RegionRequest;
import de.digitalcollections.iiif.model.image.RotationRequest;
import de.digitalcollections.iiif.model.image.SizeRequest;
import de.digitalcollections.iiif.model.interfaces.Selector;
import java.awt.Dimension;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dmfs.rfc3986.encoding.Encoded;
import org.dmfs.rfc3986.encoding.Precoded;

@JsonTypeName(value="iiif:ImageApiSelector")
public class ImageApiSelector
implements Selector {
    public static String CONTEXT = "http://iiif.io/api/annex/openannotation/context.json";
    public static final String TYPE = "iiif:ImageApiSelector";
    private static final Pattern REQUEST_PAT = Pattern.compile("/?(?<identifier>[^/]+)/(?<region>[^/]+)/(?<size>[^/]+)/(?<rotation>[^/]+)/(?<quality>[^/]+?)\\.(?<format>[^/]+?)$");
    private String identifier;
    private RegionRequest region;
    private SizeRequest size;
    private RotationRequest rotation;
    private ImageApiProfile.Quality quality;
    private ImageApiProfile.Format format;

    @JsonProperty(value="@context")
    public String getContext() {
        return CONTEXT;
    }

    @JsonProperty(value="@type")
    public String getType() {
        return TYPE;
    }

    public static ImageApiSelector fromImageApiUri(URI imageApiUri) {
        return ImageApiSelector.fromString(imageApiUri.getPath());
    }

    public static ImageApiSelector fromString(String str) {
        Matcher matcher = REQUEST_PAT.matcher(str);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Malformed IIIF Image API request: " + str);
        }
        ImageApiSelector selector = new ImageApiSelector();
        selector.setIdentifier(new Precoded((CharSequence)matcher.group("identifier")).decoded().toString());
        selector.setRegion(matcher.group("region"));
        selector.setSize(matcher.group("size"));
        selector.setRotation(matcher.group("rotation"));
        selector.setQuality(ImageApiProfile.Quality.valueOf(matcher.group("quality").toUpperCase()));
        selector.setFormat(ImageApiProfile.Format.valueOf(matcher.group("format").toUpperCase()));
        return selector;
    }

    public URI asImageApiUri(URI baseUri) {
        String baseUriString = baseUri.toString();
        if (!baseUriString.endsWith("/")) {
            baseUriString = baseUriString + "/";
        }
        return URI.create(baseUriString + this.toString());
    }

    public String toString() {
        return String.format("%s%s/%s/%s/%s.%s", this.identifier != null ? ImageApiSelector.urlEncode(this.identifier) + "/" : "", Objects.toString(this.region, "full"), Objects.toString(this.size, "full"), Objects.toString(this.rotation, "0"), Objects.toString((Object)this.quality, "default"), Objects.toString((Object)this.format, "jpg"));
    }

    private static String urlEncode(String str) {
        ImmutableSet excluded = ImmutableSet.of((Object)":", (Object)"!", (Object)"$", (Object)"&", (Object)"'", (Object)"(", (Object[])new String[]{")", "*", "+", ",", ";", "="});
        String encoded = new Encoded((CharSequence)str).toString();
        for (String ex : excluded) {
            encoded = encoded.replaceAll(new Encoded((CharSequence)ex).toString(), ex);
        }
        return encoded;
    }

    public String getCanonicalForm(Dimension nativeSize, ImageApiProfile profile, ImageApiProfile.Quality defaultQuality) {
        return String.format("%s%s/%s/%s/%s.%s", this.identifier != null ? ImageApiSelector.urlEncode(this.identifier) + "/" : "", this.region.getCanonicalForm(nativeSize), this.size.getCanonicalForm(nativeSize, profile), this.rotation.toString(), this.quality.equals((Object)defaultQuality) ? "default" : this.quality.toString(), this.format.toString());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public RegionRequest getRegion() {
        return this.region;
    }

    public void setRegion(RegionRequest region) {
        this.region = region;
    }

    public void setRegion(String region) {
        this.region = RegionRequest.fromString(region);
    }

    public SizeRequest getSize() {
        return this.size;
    }

    public void setSize(SizeRequest size) {
        this.size = size;
    }

    public void setSize(String size) {
        this.size = SizeRequest.fromString(size);
    }

    public RotationRequest getRotation() {
        return this.rotation;
    }

    public void setRotation(RotationRequest rotation) {
        this.rotation = rotation;
    }

    public void setRotation(String rotation) {
        this.rotation = RotationRequest.fromString(rotation);
    }

    public ImageApiProfile.Quality getQuality() {
        return this.quality;
    }

    public void setQuality(ImageApiProfile.Quality quality) {
        this.quality = quality;
    }

    public ImageApiProfile.Format getFormat() {
        return this.format;
    }

    public void setFormat(ImageApiProfile.Format format) {
        this.format = format;
    }
}

