/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;

public class AccessToken {
    @JsonProperty(value="accessToken")
    private String token;
    private Duration expiresIn;

    @JsonCreator
    public AccessToken(@JsonProperty(value="accessToken") String token, @JsonProperty(value="expiresIn") Duration expiresIn) {
        this.token = token;
        this.expiresIn = expiresIn;
    }

    public String getToken() {
        return this.token;
    }

    public Integer getExpiresIn() {
        return Math.toIntExact(this.expiresIn.toMillis() / 1000L);
    }

    @JsonIgnore
    public Duration getExpiresInDuration() {
        return this.expiresIn;
    }
}

