/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;

@ConfigurationProperties(prefix="custom.iiif.headers")
@ConstructorBinding
public class CustomResponseHeaders {
    private final List<ResponseHeader> imageTile;
    private final List<ResponseHeader> imageInfo;
    private final List<ResponseHeader> presentationManifest;
    private final List<ResponseHeader> presentationAnnotationList;
    private final List<ResponseHeader> presentationCollection;

    public CustomResponseHeaders(List<ResponseHeader> all, ImageResponseHeaders image, PresentationResponseHeaders presentation) {
        all = Objects.requireNonNullElseGet(all, Collections::emptyList);
        image = Objects.requireNonNullElseGet(image, ImageResponseHeaders::empty);
        presentation = Objects.requireNonNullElseGet(presentation, PresentationResponseHeaders::empty);
        this.imageTile = this.concatenate(all, image.image);
        this.imageInfo = this.concatenate(all, image.info);
        this.presentationManifest = this.concatenate(all, presentation.manifest);
        this.presentationAnnotationList = this.concatenate(all, presentation.annotationList);
        this.presentationCollection = this.concatenate(all, presentation.collection);
    }

    private List<ResponseHeader> concatenate(List<ResponseHeader> first, List<ResponseHeader> second) {
        ArrayList<ResponseHeader> result = new ArrayList<ResponseHeader>(first);
        result.addAll(second);
        return result;
    }

    public List<ResponseHeader> forImageTile() {
        return Collections.unmodifiableList(this.imageTile);
    }

    public List<ResponseHeader> forImageInfo() {
        return Collections.unmodifiableList(this.imageInfo);
    }

    public List<ResponseHeader> forPresentationManifest() {
        return Collections.unmodifiableList(this.presentationManifest);
    }

    public List<ResponseHeader> forPresentationCollection() {
        return Collections.unmodifiableList(this.presentationCollection);
    }

    public List<ResponseHeader> forPresentationAnnotationList() {
        return Collections.unmodifiableList(this.presentationAnnotationList);
    }

    public static class ResponseHeader {
        private final String name;
        private final String value;

        public ResponseHeader(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    @ConstructorBinding
    protected static class PresentationResponseHeaders {
        private final List<ResponseHeader> manifest;
        private final List<ResponseHeader> collection;
        private final List<ResponseHeader> annotationList;

        public PresentationResponseHeaders(List<ResponseHeader> manifest, List<ResponseHeader> collection, List<ResponseHeader> annotationList) {
            this.manifest = Objects.requireNonNullElseGet(manifest, Collections::emptyList);
            this.collection = Objects.requireNonNullElseGet(collection, Collections::emptyList);
            this.annotationList = Objects.requireNonNullElseGet(annotationList, Collections::emptyList);
        }

        public List<ResponseHeader> getManifest() {
            return Collections.unmodifiableList(this.manifest);
        }

        public List<ResponseHeader> getCollection() {
            return Collections.unmodifiableList(this.collection);
        }

        public List<ResponseHeader> getAnnotationList() {
            return Collections.unmodifiableList(this.annotationList);
        }

        public static PresentationResponseHeaders empty() {
            return new PresentationResponseHeaders(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
    }

    protected static class ImageResponseHeaders {
        private final List<ResponseHeader> image;
        private final List<ResponseHeader> info;

        public ImageResponseHeaders(List<ResponseHeader> image, List<ResponseHeader> info) {
            this.image = Collections.unmodifiableList(Objects.requireNonNullElseGet(image, Collections::emptyList));
            this.info = Collections.unmodifiableList(Objects.requireNonNullElseGet(info, Collections::emptyList));
        }

        public List<ResponseHeader> getImage() {
            return Collections.unmodifiableList(this.image);
        }

        public List<ResponseHeader> getInfo() {
            return Collections.unmodifiableList(this.info);
        }

        public static ImageResponseHeaders empty() {
            return new ImageResponseHeaders(Collections.emptyList(), Collections.emptyList());
        }
    }
}

