/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.config;

import de.digitalcollections.iiif.hymir.config.CustomResponseHeaders;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;

@ConfigurationProperties(prefix="custom.iiif.headers")
@ConstructorBinding
public class CustomResponseHeaders {
    private final List<ResponseHeader> imageTile;
    private final List<ResponseHeader> imageInfo;
    private final List<ResponseHeader> presentationManifest;
    private final List<ResponseHeader> presentationAnnotationList;
    private final List<ResponseHeader> presentationCollection;

    public CustomResponseHeaders(List<ResponseHeader> all, ImageResponseHeaders image, PresentationResponseHeaders presentation) {
        all = Objects.requireNonNullElseGet(all, Collections::emptyList);
        image = Objects.requireNonNullElseGet(image, ImageResponseHeaders::empty);
        presentation = Objects.requireNonNullElseGet(presentation, PresentationResponseHeaders::empty);
        this.imageTile = this.concatenate(all, image.image);
        this.imageInfo = this.concatenate(all, image.info);
        this.presentationManifest = this.concatenate(all, presentation.manifest);
        this.presentationAnnotationList = this.concatenate(all, presentation.annotationList);
        this.presentationCollection = this.concatenate(all, presentation.collection);
    }

    private List<ResponseHeader> concatenate(List<ResponseHeader> first, List<ResponseHeader> second) {
        ArrayList<ResponseHeader> result = new ArrayList<ResponseHeader>(first);
        result.addAll(second);
        return result;
    }

    public List<ResponseHeader> forImageTile() {
        return Collections.unmodifiableList(this.imageTile);
    }

    public List<ResponseHeader> forImageInfo() {
        return Collections.unmodifiableList(this.imageInfo);
    }

    public List<ResponseHeader> forPresentationManifest() {
        return Collections.unmodifiableList(this.presentationManifest);
    }

    public List<ResponseHeader> forPresentationCollection() {
        return Collections.unmodifiableList(this.presentationCollection);
    }

    public List<ResponseHeader> forPresentationAnnotationList() {
        return Collections.unmodifiableList(this.presentationAnnotationList);
    }
}

