/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.image.business;

import com.google.common.collect.Streams;
import de.digitalcollections.commons.file.backend.FileSystemResourceIOException;
import de.digitalcollections.commons.file.business.api.FileResourceService;
import de.digitalcollections.iiif.hymir.image.business.ImageMetrics;
import de.digitalcollections.iiif.hymir.image.business.api.ImageSecurityService;
import de.digitalcollections.iiif.hymir.image.business.api.ImageService;
import de.digitalcollections.iiif.hymir.model.exception.InvalidParametersException;
import de.digitalcollections.iiif.hymir.model.exception.ScalingException;
import de.digitalcollections.iiif.hymir.model.exception.UnsupportedFormatException;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.ImageApiSelector;
import de.digitalcollections.iiif.model.image.ResolvingException;
import de.digitalcollections.iiif.model.image.Size;
import de.digitalcollections.iiif.model.image.SizeRequest;
import de.digitalcollections.iiif.model.image.TileInfo;
import de.digitalcollections.model.exception.ResourceIOException;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.turbojpeg.imageio.TurboJpegImageReadParam;
import de.digitalcollections.turbojpeg.imageio.TurboJpegImageReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.imgscalr.Scalr;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ImageServiceImpl
implements ImageService {
    @Autowired
    private HttpServletRequest currentRequest;
    private final ImageSecurityService imageSecurityService;
    private final FileResourceService fileResourceService;
    private final ImageMetrics metrics;
    @Value(value="${custom.iiif.logo:}")
    private String logoUrl;
    @Value(value="${custom.iiif.attribution:}")
    private String attribution;
    @Value(value="${custom.iiif.license:}")
    private String license;
    @Value(value="${custom.iiif.image.maxWidth:65500}")
    private int maxWidth;
    @Value(value="${custom.iiif.image.maxHeight:65500}")
    private int maxHeight;

    public static boolean containsAlphaChannel(BufferedImage image) {
        return image.getColorModel().hasAlpha();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is intended for the metrics component \uf61b")
    public ImageServiceImpl(@Autowired(required=false) ImageSecurityService imageSecurityService, @Autowired FileResourceService fileResourceService, @Autowired ImageMetrics metrics) {
        this.imageSecurityService = imageSecurityService;
        this.fileResourceService = fileResourceService;
        this.metrics = metrics;
    }

    private void enrichInfo(ImageReader reader, de.digitalcollections.iiif.model.image.ImageService info) throws IOException {
        ImageApiProfile profile = new ImageApiProfile();
        profile.addFeature(ImageApiProfile.Feature.PROFILE_LINK_HEADER, new ImageApiProfile.Feature[]{ImageApiProfile.Feature.CANONICAL_LINK_HEADER, ImageApiProfile.Feature.REGION_SQUARE, ImageApiProfile.Feature.ROTATION_BY_90S, ImageApiProfile.Feature.MIRRORING, ImageApiProfile.Feature.SIZE_ABOVE_FULL});
        profile.addFormat(ImageApiProfile.Format.GIF, new ImageApiProfile.Format[]{ImageApiProfile.Format.JPG, ImageApiProfile.Format.PNG, ImageApiProfile.Format.TIF, ImageApiProfile.Format.WEBP});
        if (reader.getHeight(0) > this.maxHeight || reader.getWidth(0) > this.maxWidth) {
            profile.setMaxWidth(Integer.valueOf(this.maxWidth));
            if (this.maxHeight != this.maxWidth) {
                profile.setMaxHeight(Integer.valueOf(this.maxHeight));
            }
        }
        info.addProfile((Profile)ImageApiProfile.LEVEL_TWO, new Profile[]{profile});
        info.setWidth(Integer.valueOf(reader.getWidth(0)));
        info.setHeight(Integer.valueOf(reader.getHeight(0)));
        int numImages = reader.getNumImages(true);
        if (numImages > 1) {
            for (int i = 0; i < numImages; ++i) {
                int width = reader.getWidth(i);
                int height = reader.getHeight(i);
                if (width <= 1 || height <= 1 || width > this.maxWidth || height > this.maxHeight) continue;
                info.addSize(new Size(reader.getWidth(i), reader.getHeight(i)), new Size[0]);
            }
        }
        if (reader.isImageTiled(0)) {
            int width = reader.getTileWidth(0);
            TileInfo tileInfo = new TileInfo(Integer.valueOf(width));
            for (int i = 0; i < numImages; ++i) {
                int scaledWidth = reader.getTileWidth(i);
                tileInfo.addScaleFactor(Integer.valueOf(width / scaledWidth), new Integer[0]);
            }
            info.addTile(tileInfo, new TileInfo[0]);
        } else if (reader instanceof TurboJpegImageReader) {
            if (reader.getWidth(0) >= 512 && reader.getHeight(0) >= 512) {
                TileInfo ti = new TileInfo(Integer.valueOf(512));
                ti.addScaleFactor(Integer.valueOf(1), new Integer[]{2, 4, 8, 16});
                info.addTile(ti, new TileInfo[0]);
            }
            if (reader.getWidth(0) >= 1024 && reader.getHeight(0) >= 1024) {
                TileInfo ti = new TileInfo(Integer.valueOf(1024));
                ti.addScaleFactor(Integer.valueOf(1), new Integer[]{2, 4, 8, 16});
                info.addTile(ti, new TileInfo[0]);
            }
        }
    }

    private ImageReader getReader(String identifier) throws ResourceNotFoundException, UnsupportedFormatException, IOException {
        if (this.imageSecurityService != null && !this.imageSecurityService.isAccessAllowed(identifier, this.currentRequest)) {
            throw new ResourceNotFoundException();
        }
        try {
            FileResource fileResource = this.fileResourceService.find(identifier, MimeType.MIME_IMAGE);
            ImageInputStream iis = ImageIO.createImageInputStream(this.fileResourceService.getInputStream(fileResource));
            ImageReader reader = (ImageReader)Streams.stream(ImageIO.getImageReaders(iis)).findFirst().orElseThrow(UnsupportedFormatException::new);
            reader.setInput(iis);
            return reader;
        }
        catch (FileSystemResourceIOException e) {
            throw new IOException(e);
        }
        catch (ResourceIOException e) {
            throw new ResourceNotFoundException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readImageInfo(String identifier, de.digitalcollections.iiif.model.image.ImageService info) throws UnsupportedFormatException, UnsupportedOperationException, ResourceNotFoundException, IOException {
        ImageReader r = null;
        int metricKey = this.metrics.startImageOp();
        try {
            URI license;
            r = this.getReader(identifier);
            this.enrichInfo(r, info);
            this.metrics.endImageOp(metricKey, ImageMetrics.ImageDataOp.GET_INFO, r.getFormatName().toLowerCase(Locale.ROOT), info.getWidth() * info.getHeight());
            if (!this.logoUrl.isEmpty()) {
                info.addLogo(this.logoUrl, new String[0]);
            }
            if (!this.attribution.isEmpty()) {
                info.addAttribution(this.attribution, new String[0]);
            }
            if (!this.license.isEmpty()) {
                info.addLicense(this.license, new String[0]);
            } else if (this.imageSecurityService != null && (license = this.imageSecurityService.getLicense(identifier)) != null) {
                info.addLicense(license.toString(), new String[0]);
            }
        }
        finally {
            this.metrics.clearTimer(metricKey);
            if (r != null) {
                r.dispose();
            }
        }
    }

    static ImageReadParam getReadParam(ImageReader reader, ImageApiSelector selector, int decodeIdx) throws IOException, InvalidParametersException {
        Rectangle targetRegion;
        ImageReadParam readParam = reader.getDefaultReadParam();
        Dimension nativeDimensions = new Dimension(reader.getWidth(0), reader.getHeight(0));
        Dimension decodeDimensions = new Dimension(reader.getWidth(decodeIdx), reader.getHeight(decodeIdx));
        double decodeScaleFactor = decodeDimensions.getWidth() / nativeDimensions.getWidth();
        try {
            targetRegion = selector.getRegion().resolve(nativeDimensions);
        }
        catch (ResolvingException e) {
            throw new InvalidParametersException((Exception)((Object)e));
        }
        Rectangle decodeRegion = new Rectangle(Math.min((int)Math.floor(targetRegion.getX() * decodeScaleFactor), decodeDimensions.width), Math.min((int)Math.floor(targetRegion.getY() * decodeScaleFactor), decodeDimensions.height), Math.min((int)Math.ceil(targetRegion.getWidth() * decodeScaleFactor), decodeDimensions.width), Math.min((int)Math.ceil(targetRegion.getHeight() * decodeScaleFactor), decodeDimensions.height));
        readParam.setSourceRegion(decodeRegion);
        if (selector.getRotation().getRotation() != 0.0 && reader instanceof TurboJpegImageReader) {
            ((TurboJpegImageReadParam)readParam).setRotationDegree((int)selector.getRotation().getRotation());
        }
        return readParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DecodedImage readImage(String identifier, ImageApiSelector selector, ImageApiProfile profile) throws IOException, ResourceNotFoundException, UnsupportedFormatException, InvalidParametersException, ScalingException {
        int metricKey = this.metrics.startImageOp();
        ImageReader reader = null;
        try {
            Dimension targetSize;
            Rectangle targetRegion;
            reader = this.getReader(identifier);
            if (selector.getRotation().getRotation() % 90.0 != 0.0) {
                throw new UnsupportedOperationException("Can only rotate by multiples of 90 degrees.");
            }
            Dimension nativeDimensions = new Dimension(reader.getWidth(0), reader.getHeight(0));
            try {
                targetRegion = selector.getRegion().resolve(nativeDimensions);
            }
            catch (ResolvingException e) {
                throw new InvalidParametersException((Exception)((Object)e));
            }
            Dimension croppedDimensions = new Dimension(targetRegion.width, targetRegion.height);
            try {
                targetSize = selector.getSize().resolve(croppedDimensions, profile);
            }
            catch (ResolvingException e) {
                throw new InvalidParametersException((Exception)((Object)e));
            }
            double targetScaleFactor = (double)targetSize.width / targetRegion.getWidth();
            int targetWidth = targetSize.width;
            double decodeScaleFactor = 1.0;
            int decodeImageIndex = 0;
            for (int idx = 0; idx < reader.getNumImages(true); ++idx) {
                double candidateFactor = (double)reader.getWidth(idx) / (double)nativeDimensions.width;
                if (Math.floor(candidateFactor * targetRegion.getWidth()) < (double)targetWidth || !(Math.abs(targetScaleFactor - candidateFactor) < Math.abs(targetScaleFactor - decodeScaleFactor))) continue;
                decodeScaleFactor = candidateFactor;
                decodeImageIndex = idx;
            }
            ImageReadParam readParam = ImageServiceImpl.getReadParam(reader, selector, decodeImageIndex);
            int rotation = (int)selector.getRotation().getRotation();
            if (readParam instanceof TurboJpegImageReadParam && ((TurboJpegImageReadParam)readParam).getRotationDegree() != 0) {
                if (rotation == 90 || rotation == 270) {
                    int w = targetSize.width;
                    targetSize.width = targetSize.height;
                    targetSize.height = w;
                }
                rotation = 0;
            }
            if (targetSize.width <= 0 || targetSize.height <= 0) {
                throw new ScalingException("Scaling resulted in width or height \u2264 0: " + targetSize);
            }
            DecodedImage decoded = new DecodedImage(reader.read(decodeImageIndex, readParam), targetSize, rotation);
            this.metrics.endImageOp(metricKey, ImageMetrics.ImageDataOp.DECODE, reader.getFormatName().toLowerCase(Locale.ROOT), decoded.targetSize.width * decoded.targetSize.height);
            DecodedImage decodedImage = decoded;
            return decodedImage;
        }
        finally {
            this.metrics.clearTimer(metricKey);
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    private BufferedImage transformImage(BufferedImage inputImage, Dimension targetSize, int rotation, boolean mirror, ImageApiProfile.Quality quality) {
        int outType;
        BufferedImage img = inputImage;
        int inType = img.getType();
        boolean needsAdditionalScaling = !new Dimension(img.getWidth(), img.getHeight()).equals(targetSize);
        int metricKey = this.metrics.startImageOp();
        if (needsAdditionalScaling) {
            img = Scalr.resize((BufferedImage)img, (Scalr.Method)Scalr.Method.BALANCED, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetSize.width, (int)targetSize.height, (BufferedImageOp[])new BufferedImageOp[0]);
        }
        if (mirror) {
            img = Scalr.rotate((BufferedImage)img, (Scalr.Rotation)Scalr.Rotation.FLIP_HORZ, (BufferedImageOp[])new BufferedImageOp[0]);
        }
        if (rotation != 0) {
            Scalr.Rotation rot;
            switch (rotation) {
                case 90: {
                    rot = Scalr.Rotation.CW_90;
                    break;
                }
                case 180: {
                    rot = Scalr.Rotation.CW_180;
                    break;
                }
                case 270: {
                    rot = Scalr.Rotation.CW_270;
                    break;
                }
                default: {
                    rot = null;
                }
            }
            img = Scalr.rotate((BufferedImage)img, (Scalr.Rotation)rot, (BufferedImageOp[])new BufferedImageOp[0]);
        }
        switch (quality) {
            case GRAY: {
                outType = 10;
                break;
            }
            case BITONAL: {
                outType = 12;
                break;
            }
            case COLOR: {
                outType = 5;
                break;
            }
            default: {
                outType = inType;
            }
        }
        if (outType != img.getType()) {
            BufferedImage newImg = new BufferedImage(img.getWidth(), img.getHeight(), outType);
            Graphics2D g2d = newImg.createGraphics();
            g2d.drawImage((Image)img, 0, 0, null);
            img = newImg;
            g2d.dispose();
        }
        this.metrics.endImageOp(metricKey, ImageMetrics.ImageDataOp.TRANSFORM, inputImage.getWidth() * inputImage.getHeight());
        return img;
    }

    @Override
    public void processImage(String identifier, ImageApiSelector selector, ImageApiProfile profile, OutputStream os) throws InvalidParametersException, UnsupportedOperationException, UnsupportedFormatException, ResourceNotFoundException, IOException, ScalingException {
        Rectangle2D region = selector.getRegion().getRegion();
        if (region != null && (region.getWidth() < 1.0 || region.getHeight() < 1.0)) {
            String message = String.format(Locale.ROOT, "requested region has to have at least one pixel, but was [x=%.2f, y=%.2f, width=%.2f, height=%.2f]", region.getX(), region.getY(), region.getWidth(), region.getHeight());
            throw new InvalidParametersException(message);
        }
        SizeRequest size = selector.getSize();
        if (size.getWidth() != null && size.getWidth() < 1 || size.getHeight() != null && size.getHeight() < 1) {
            throw new InvalidParametersException("requested size has to be at least one pixel, but was " + size);
        }
        DecodedImage decodedImage = this.readImage(identifier, selector, profile);
        boolean containsAlphaChannel = ImageServiceImpl.containsAlphaChannel(decodedImage.img);
        if (containsAlphaChannel) {
            int alphaMetricKey = this.metrics.startImageOp();
            int type = decodedImage.img.getType();
            if (2 != type) {
                BufferedImage convertedImage = new BufferedImage(decodedImage.img.getWidth(), decodedImage.img.getHeight(), 2);
                convertedImage.getGraphics().drawImage(decodedImage.img, 0, 0, null);
                convertedImage.getGraphics().dispose();
                decodedImage = new DecodedImage(convertedImage, decodedImage.targetSize, decodedImage.rotation);
                this.metrics.endImageOp(alphaMetricKey, ImageMetrics.ImageDataOp.ALPHACONVERT, decodedImage.getPixelSize());
            }
        }
        BufferedImage outImg = this.transformImage(decodedImage.img, decodedImage.targetSize, decodedImage.rotation, selector.getRotation().isMirror(), selector.getQuality());
        int encodeMetricKey = this.metrics.startImageOp();
        ImageWriter writer = (ImageWriter)Streams.stream(ImageIO.getImageWriters(new ImageTypeSpecifier(outImg), selector.getFormat().name())).findFirst().orElseThrow(UnsupportedFormatException::new);
        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
        writer.setOutput(ios);
        writer.write(outImg);
        this.metrics.endImageOp(encodeMetricKey, ImageMetrics.ImageDataOp.ENCODE, decodedImage.getPixelSize());
        writer.dispose();
        ios.flush();
    }

    @Override
    public Instant getImageModificationDate(String identifier) throws ResourceNotFoundException {
        if (this.imageSecurityService != null && !this.imageSecurityService.isAccessAllowed(identifier, this.currentRequest)) {
            throw new ResourceNotFoundException();
        }
        try {
            FileResource res = this.fileResourceService.find(identifier, MimeType.MIME_IMAGE);
            return res.getLastModified().toInstant(ZoneOffset.UTC);
        }
        catch (ResourceIOException e) {
            throw new ResourceNotFoundException();
        }
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    private static class DecodedImage {
        final BufferedImage img;
        final Dimension targetSize;
        final int rotation;

        protected DecodedImage(BufferedImage img, Dimension targetSize, int rotation) {
            this.img = img;
            this.targetSize = targetSize;
            this.rotation = rotation;
        }

        public int getPixelSize() {
            return this.img.getWidth() * this.img.getHeight();
        }
    }
}

