/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.image.business;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import de.digitalcollections.iiif.hymir.image.business.ImageMetrics;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ImageMetrics {
    private static final String DATA_OP_TIMER = "hymir.image.data.op.duration.seconds";
    private static final String DATA_OP_PIX_COUNTER = "hymir.image.data.op.pixels.total";
    private static final Random rng = new Random();
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="We need the registry \uf61b")
    private final MeterRegistry registry;
    private final ConcurrentMap<String, Timer> timers = new ConcurrentHashMap();
    private final ConcurrentMap<String, Counter> counters = new ConcurrentHashMap();
    private final ConcurrentMap<Integer, Long> runningTimers = new ConcurrentHashMap();

    public ImageMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    private String buildMetricKey(String name, String ... tags) {
        Hasher hasher = Hashing.sha256().newHasher();
        hasher.putString((CharSequence)name, StandardCharsets.UTF_8);
        Arrays.stream(tags).forEach(t -> hasher.putString((CharSequence)t, StandardCharsets.UTF_8));
        return hasher.hash().toString();
    }

    private String[] buildTags(ImageDataOp op, String format) {
        ArrayList<String> tagList = new ArrayList<String>();
        tagList.add("op");
        tagList.add(op.toString().toLowerCase(Locale.ROOT));
        if (format != null) {
            tagList.add("format");
            tagList.add(format.toLowerCase(Locale.ROOT));
        }
        return (String[])tagList.toArray(String[]::new);
    }

    public void clearTimer(int key) {
        this.runningTimers.remove(key);
    }

    @Scheduled(fixedRate=15L, timeUnit=TimeUnit.MINUTES)
    public void clearStaleTimers() {
        long now = System.nanoTime();
        this.runningTimers.entrySet().stream().filter(e -> now - (Long)e.getValue() > (long)Duration.ofMinutes(5L).getNano()).forEach(e -> this.runningTimers.remove(e.getKey()));
    }

    public int startImageOp() {
        int key = rng.nextInt();
        this.runningTimers.put(key, System.nanoTime());
        return key;
    }

    public void endImageOp(int key, ImageDataOp op, int numPixels) {
        this.endImageOp(key, op, null, numPixels);
    }

    public void endImageOp(int key, ImageDataOp op, String format, int numPixels) {
        Long startTime = (Long)this.runningTimers.remove(key);
        if (startTime == null) {
            return;
        }
        String[] tags = this.buildTags(op, format);
        this.timers.computeIfAbsent(this.buildMetricKey(DATA_OP_TIMER, tags), k -> Timer.builder((String)DATA_OP_TIMER).description("Latency for operations on image data").tags(tags).register(this.registry)).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        this.counters.computeIfAbsent(this.buildMetricKey(DATA_OP_PIX_COUNTER, tags), k -> Counter.builder((String)DATA_OP_PIX_COUNTER).description("Number of input pixels processed in an image data operation").tags(tags).register(this.registry)).increment((double)numPixels);
    }
}

