/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.presentation.backend;

import de.digitalcollections.commons.file.backend.FileSystemResourceIOException;
import de.digitalcollections.commons.file.business.api.FileResourceService;
import de.digitalcollections.iiif.hymir.model.exception.InvalidDataException;
import de.digitalcollections.iiif.hymir.model.exception.ResolvingException;
import de.digitalcollections.iiif.hymir.presentation.backend.api.PresentationRepository;
import de.digitalcollections.iiif.model.jackson.IiifObjectMapper;
import de.digitalcollections.iiif.model.sharedcanvas.AnnotationList;
import de.digitalcollections.iiif.model.sharedcanvas.Collection;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import de.digitalcollections.model.exception.ResourceIOException;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.resource.FileResource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PresentationRepositoryImpl
implements PresentationRepository {
    private static final String COLLECTION_PREFIX = "collection-";
    private static final Logger LOGGER = LoggerFactory.getLogger(PresentationRepositoryImpl.class);
    @Autowired
    private IiifObjectMapper objectMapper;
    @Autowired
    private FileResourceService fileResourceService;

    public AnnotationList getAnnotationList(String identifier, String name, String canvasId) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        FileResource resource;
        String annotationListName = name + "-" + identifier + "_" + canvasId;
        try {
            resource = this.fileResourceService.find(annotationListName, MimeType.MIME_APPLICATION_JSON);
        }
        catch (FileSystemResourceIOException e) {
            throw new RuntimeException(e);
        }
        catch (ResourceIOException ex) {
            LOGGER.error("Error getting annotation list for name {}", (Object)annotationListName, (Object)ex);
            throw new ResolvingException("No annotation list for name " + annotationListName);
        }
        try {
            return (AnnotationList)this.objectMapper.readValue(this.getResourceJson(resource), AnnotationList.class);
        }
        catch (FileSystemResourceIOException e) {
            throw new RuntimeException(e);
        }
        catch (IOException ex) {
            LOGGER.error("Could not retrieve annotation list {}", (Object)annotationListName, (Object)ex);
            throw new InvalidDataException("Annotation list " + annotationListName + " can not be parsed", (Exception)ex);
        }
    }

    public Collection getCollection(String name) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        FileResource resource;
        String collectionName = COLLECTION_PREFIX + name;
        try {
            resource = this.fileResourceService.find(collectionName, MimeType.MIME_APPLICATION_JSON);
        }
        catch (FileSystemResourceIOException e) {
            throw new RuntimeException(e);
        }
        catch (ResourceIOException ex) {
            LOGGER.error("Error getting manifest for collection {}", (Object)name, (Object)ex);
            throw new ResolvingException("No collection for name " + name);
        }
        try {
            return (Collection)this.objectMapper.readValue(this.getResourceJson(resource), Collection.class);
        }
        catch (FileSystemResourceIOException e) {
            throw new RuntimeException(e);
        }
        catch (IOException ex) {
            LOGGER.info("Could not retrieve collection {}", (Object)collectionName, (Object)ex);
            throw new InvalidDataException("Collection for name " + collectionName + " can not be parsed", (Exception)ex);
        }
    }

    public Manifest getManifest(String identifier) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        FileResource resource;
        try {
            resource = this.fileResourceService.find(identifier, MimeType.MIME_APPLICATION_JSON);
        }
        catch (FileSystemResourceIOException e) {
            throw new RuntimeException(e);
        }
        catch (ResourceIOException ex) {
            LOGGER.error("Error getting manifest for identifier {}", (Object)identifier, (Object)ex);
            throw new ResolvingException("No manifest for identifier " + identifier);
        }
        try {
            return (Manifest)this.objectMapper.readValue(this.getResourceJson(resource), Manifest.class);
        }
        catch (FileSystemResourceIOException e) {
            throw new RuntimeException(e);
        }
        catch (IOException ex) {
            LOGGER.error("Manifest {} can not be parsed", (Object)identifier, (Object)ex);
            throw new InvalidDataException("Manifest " + identifier + " can not be parsed", (Exception)ex);
        }
    }

    public Instant getManifestModificationDate(String identifier) throws ResolvingException, ResourceNotFoundException {
        return this.getResourceModificationDate(identifier);
    }

    public Instant getCollectionModificationDate(String identifier) throws ResolvingException, ResourceNotFoundException {
        return this.getResourceModificationDate(identifier);
    }

    private Instant getResourceModificationDate(String identifier) throws ResolvingException, ResourceNotFoundException {
        try {
            FileResource resource = this.fileResourceService.find(identifier, MimeType.MIME_APPLICATION_JSON);
            return resource.getLastModified().toInstant(ZoneOffset.UTC);
        }
        catch (FileSystemResourceIOException e) {
            throw new RuntimeException(e);
        }
        catch (ResourceIOException ex) {
            LOGGER.error("Error getting resource for identifier '{}', message '{}'", (Object)identifier, (Object)ex.getMessage());
            throw new ResolvingException("No manifest for identifier " + identifier);
        }
    }

    protected String getResourceJson(FileResource resource) throws ResourceIOException, ResourceNotFoundException {
        return this.fileResourceService.getAsString(resource, StandardCharsets.UTF_8);
    }
}

