/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.presentation.business.api;

import de.digitalcollections.iiif.hymir.model.exception.InvalidDataException;
import de.digitalcollections.iiif.hymir.model.exception.ResolvingException;
import de.digitalcollections.iiif.model.sharedcanvas.AnnotationList;
import de.digitalcollections.iiif.model.sharedcanvas.Canvas;
import de.digitalcollections.iiif.model.sharedcanvas.Collection;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import de.digitalcollections.iiif.model.sharedcanvas.Range;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import de.digitalcollections.iiif.model.sharedcanvas.Sequence;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import java.net.URI;
import java.time.Instant;

public interface PresentationService {
    public AnnotationList getAnnotationList(String var1, String var2, String var3) throws ResolvingException, ResourceNotFoundException, InvalidDataException;

    public Collection getCollection(String var1) throws ResolvingException, ResourceNotFoundException, InvalidDataException;

    public Manifest getManifest(String var1) throws ResolvingException, ResourceNotFoundException, InvalidDataException;

    default public Instant getManifestModificationDate(String identifier) throws ResolvingException, ResourceNotFoundException {
        return Instant.now();
    }

    default public Instant getCollectionModificationDate(String identifier) throws ResolvingException, ResourceNotFoundException {
        return Instant.now();
    }

    default public Canvas getCanvas(String manifestId, String canvasUri) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        return this.getCanvas(manifestId, URI.create(canvasUri));
    }

    default public Canvas getCanvas(String manifestId, URI canvasUri) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        Manifest manifest = this.getManifest(manifestId);
        return manifest.getSequences().stream().flatMap(seq -> seq.getCanvases().stream()).filter(canv -> canv.getIdentifier().equals(canvasUri)).map(canv -> (Canvas)this.copyAttributionInfo(manifest, (Resource)canv)).findFirst().orElseThrow(ResolvingException::new);
    }

    default public Range getRange(String manifestId, String rangeUri) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        return this.getRange(manifestId, URI.create(rangeUri));
    }

    default public Range getRange(String manifestId, URI rangeUri) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        Manifest manifest = this.getManifest(manifestId);
        return manifest.getRanges().stream().filter(r -> r.getIdentifier().equals(rangeUri)).map(r -> (Range)this.copyAttributionInfo(manifest, (Resource)r)).findFirst().orElseThrow(ResolvingException::new);
    }

    default public Sequence getSequence(String manifestId, String sequenceUri) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        return this.getSequence(manifestId, URI.create(sequenceUri));
    }

    default public Sequence getSequence(String manifestId, URI sequenceUri) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        Manifest manifest = this.getManifest(manifestId);
        return manifest.getSequences().stream().filter(s -> s.getIdentifier().equals(sequenceUri)).map(s -> (Sequence)this.copyAttributionInfo(manifest, (Resource)s)).findFirst().orElseThrow(ResolvingException::new);
    }

    default public <T extends Resource> T copyAttributionInfo(Manifest manifest, T res) {
        res.setLogos(manifest.getLogos());
        res.setAttribution(manifest.getAttribution());
        res.setLicenses(manifest.getLicenses());
        return res;
    }
}

