/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.presentation.frontend;

import de.digitalcollections.commons.springboot.metrics.MetricsService;
import de.digitalcollections.iiif.hymir.config.CustomResponseHeaders;
import de.digitalcollections.iiif.hymir.model.exception.InvalidDataException;
import de.digitalcollections.iiif.hymir.model.exception.ResolvingException;
import de.digitalcollections.iiif.hymir.presentation.business.api.PresentationService;
import de.digitalcollections.iiif.hymir.util.UrlRules;
import de.digitalcollections.iiif.model.sharedcanvas.AnnotationList;
import de.digitalcollections.iiif.model.sharedcanvas.Canvas;
import de.digitalcollections.iiif.model.sharedcanvas.Collection;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import de.digitalcollections.iiif.model.sharedcanvas.Range;
import de.digitalcollections.iiif.model.sharedcanvas.Sequence;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import java.net.URI;
import java.time.Instant;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;

@Controller
@RequestMapping(value={"${custom.iiif.presentation.urlPrefix:/presentation/v2}"})
public class IIIFPresentationApiController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IIIFPresentationApiController.class);
    public static final String VERSION = "v2";
    @Autowired
    protected CustomResponseHeaders customResponseHeaders;
    @Autowired
    private PresentationService presentationService;
    @Autowired
    private MetricsService metricsService;

    @RequestMapping(value={"{identifier}/manifest", "{identifier}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Manifest getManifest(@PathVariable String identifier, WebRequest request, HttpServletResponse resp) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        if (UrlRules.isInsecure((String)identifier)) {
            resp.setStatus(400);
            return null;
        }
        long modified = this.presentationService.getManifestModificationDate(identifier).toEpochMilli();
        if (request.checkNotModified(modified)) {
            return null;
        }
        long generationDuration = System.currentTimeMillis();
        Manifest manifest = this.presentationService.getManifest(identifier);
        generationDuration = System.currentTimeMillis() - generationDuration;
        this.metricsService.increaseCounterWithDurationAndPercentiles("generations", "manifest", Long.valueOf(generationDuration));
        resp.setDateHeader("Last-Modified", modified);
        resp.addHeader("Access-Control-Allow-Origin", "*");
        this.customResponseHeaders.forPresentationManifest().forEach(customResponseHeader -> resp.setHeader(customResponseHeader.getName(), customResponseHeader.getValue()));
        LOGGER.info("Serving manifest for {}", (Object)identifier);
        return manifest;
    }

    @RequestMapping(value={"{identifier}/manifest", "{identifier}"}, method={RequestMethod.HEAD})
    public void checkManifest(@PathVariable String identifier, HttpServletResponse resp) throws ResolvingException, ResourceNotFoundException {
        if (UrlRules.isInsecure((String)identifier)) {
            resp.setStatus(400);
            return;
        }
        Instant modDate = this.presentationService.getManifestModificationDate(identifier);
        resp.setDateHeader("Last-Modified", modDate.toEpochMilli());
        resp.addHeader("Access-Control-Allow-Origin", "*");
        this.customResponseHeaders.forPresentationManifest().forEach(customResponseHeader -> resp.setHeader(customResponseHeader.getName(), customResponseHeader.getValue()));
        resp.setStatus(200);
    }

    @RequestMapping(value={"{manifestId}/canvas/{canvasId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Canvas getCanvas(@PathVariable String manifestId, @PathVariable String canvasId, HttpServletRequest req, HttpServletResponse resp) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        if (UrlRules.anyIsInsecure((String[])new String[]{manifestId, canvasId})) {
            resp.setStatus(400);
            return null;
        }
        resp.addHeader("Access-Control-Allow-Origin", "*");
        this.customResponseHeaders.forPresentationManifest().forEach(customResponseHeader -> resp.setHeader(customResponseHeader.getName(), customResponseHeader.getValue()));
        return this.presentationService.getCanvas(manifestId, this.getOriginalUri(req));
    }

    @RequestMapping(value={"{manifestId}/range/{rangeId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Range getRange(@PathVariable String manifestId, @PathVariable String rangeId, HttpServletRequest req, HttpServletResponse resp) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        if (UrlRules.anyIsInsecure((String[])new String[]{manifestId, rangeId})) {
            resp.setStatus(400);
            return null;
        }
        resp.addHeader("Access-Control-Allow-Origin", "*");
        this.customResponseHeaders.forPresentationManifest().forEach(customResponseHeader -> resp.setHeader(customResponseHeader.getName(), customResponseHeader.getValue()));
        return this.presentationService.getRange(manifestId, this.getOriginalUri(req));
    }

    @RequestMapping(value={"{manifestId}/sequence/{sequenceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Sequence getSequence(@PathVariable String manifestId, @PathVariable String sequenceId, HttpServletRequest req, HttpServletResponse resp) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        if (UrlRules.anyIsInsecure((String[])new String[]{manifestId, sequenceId})) {
            resp.setStatus(400);
            return null;
        }
        resp.addHeader("Access-Control-Allow-Origin", "*");
        this.customResponseHeaders.forPresentationManifest().forEach(customResponseHeader -> resp.setHeader(customResponseHeader.getName(), customResponseHeader.getValue()));
        return this.presentationService.getSequence(manifestId, this.getOriginalUri(req));
    }

    @RequestMapping(value={"collection/{identifier}"}, method={RequestMethod.GET, RequestMethod.HEAD}, produces={"application/json"})
    @ResponseBody
    public Collection getCollection(@PathVariable String identifier, WebRequest request, HttpServletResponse resp) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        if (UrlRules.isInsecure((String)identifier)) {
            resp.setStatus(400);
            return null;
        }
        long modified = this.presentationService.getCollectionModificationDate(identifier).toEpochMilli();
        resp.addHeader("Access-Control-Allow-Origin", "*");
        this.customResponseHeaders.forPresentationCollection().forEach(customResponseHeader -> resp.setHeader(customResponseHeader.getName(), customResponseHeader.getValue()));
        if (request.checkNotModified(modified)) {
            return null;
        }
        Collection collection = this.presentationService.getCollection(identifier);
        LOGGER.info("Serving collection for {}", (Object)identifier);
        return collection;
    }

    @GetMapping(value={"{identifier}/list/{name}/{canvasId}"}, produces={"application/json"})
    @ResponseBody
    public AnnotationList getAnnotationList(@PathVariable String identifier, @PathVariable String name, @PathVariable String canvasId, HttpServletResponse resp) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        if (UrlRules.anyIsInsecure((String[])new String[]{identifier, name, canvasId})) {
            resp.setStatus(400);
            return null;
        }
        resp.addHeader("Access-Control-Allow-Origin", "*");
        this.customResponseHeaders.forPresentationAnnotationList().forEach(customResponseHeader -> resp.setHeader(customResponseHeader.getName(), customResponseHeader.getValue()));
        LOGGER.info("Serving annotation list for {}-{}_{}", new Object[]{name, identifier, canvasId});
        return this.presentationService.getAnnotationList(identifier, name, canvasId);
    }

    private URI getOriginalUri(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().toString();
        String incomingScheme = URI.create(requestUrl).getScheme();
        String originalScheme = request.getHeader("X-Forwarded-Proto");
        if (originalScheme != null && !incomingScheme.equals(originalScheme)) {
            return URI.create(requestUrl.replaceFirst("^" + incomingScheme, originalScheme));
        }
        return URI.create(requestUrl);
    }
}

