/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.presentation.business;

import de.digitalcollections.iiif.hymir.model.exception.InvalidDataException;
import de.digitalcollections.iiif.hymir.model.exception.ResolvingException;
import de.digitalcollections.iiif.hymir.presentation.backend.api.PresentationRepository;
import de.digitalcollections.iiif.hymir.presentation.business.api.PresentationSecurityService;
import de.digitalcollections.iiif.hymir.presentation.business.api.PresentationService;
import de.digitalcollections.iiif.model.sharedcanvas.AnnotationList;
import de.digitalcollections.iiif.model.sharedcanvas.Collection;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import de.digitalcollections.model.api.identifiable.resource.exceptions.ResourceNotFoundException;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PresentationServiceImpl
implements PresentationService {
    private final PresentationRepository presentationRepository;
    private final PresentationSecurityService presentationSecurityService;

    @Autowired
    public PresentationServiceImpl(PresentationRepository presentationRepository, @Autowired(required=false) PresentationSecurityService presentationSecurityService) {
        this.presentationRepository = presentationRepository;
        this.presentationSecurityService = presentationSecurityService;
    }

    public AnnotationList getAnnotationList(String identifier, String name, String canvasId) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        return this.presentationRepository.getAnnotationList(identifier, name, canvasId);
    }

    public Collection getCollection(String name) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        return this.presentationRepository.getCollection(name);
    }

    public Manifest getManifest(String identifier) throws ResolvingException, ResourceNotFoundException, InvalidDataException {
        if (this.presentationSecurityService != null && !this.presentationSecurityService.isAccessAllowed(identifier)) {
            throw new ResolvingException();
        }
        return this.presentationRepository.getManifest(identifier);
    }

    public Instant getManifestModificationDate(String identifier) throws ResolvingException, ResourceNotFoundException {
        return this.presentationRepository.getManifestModificationDate(identifier);
    }

    public Instant getCollectionModificationDate(String identifier) throws ResolvingException, ResourceNotFoundException {
        return this.presentationRepository.getCollectionModificationDate(identifier);
    }
}

