/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="custom.iiif.headers")
public class CustomResponseHeaders {
    private List<ResponseHeader> all = new ArrayList<ResponseHeader>();
    private HashMap<String, List<ResponseHeader>> image = new HashMap();
    private HashMap<String, List<ResponseHeader>> presentation = new HashMap();

    public void setAll(List<ResponseHeader> all) {
        this.all = all;
    }

    public List<ResponseHeader> getAll() {
        return this.all;
    }

    public HashMap<String, List<ResponseHeader>> getImage() {
        return this.image;
    }

    public void setImage(HashMap<String, List<ResponseHeader>> image) {
        this.image = image;
    }

    public void setPresentation(HashMap<String, List<ResponseHeader>> presentation) {
        this.presentation = presentation;
    }

    public HashMap<String, List<ResponseHeader>> getPresentation() {
        return this.presentation;
    }

    public List<ResponseHeader> forImageTile() {
        ArrayList<ResponseHeader> result = new ArrayList<ResponseHeader>();
        Optional.ofNullable(this.all).ifPresent(result::addAll);
        Optional.ofNullable(this.image.get("image")).ifPresent(result::addAll);
        return result;
    }

    public List<ResponseHeader> forImageInfo() {
        ArrayList<ResponseHeader> result = new ArrayList<ResponseHeader>();
        Optional.ofNullable(this.all).ifPresent(result::addAll);
        Optional.ofNullable(this.image.get("info")).ifPresent(result::addAll);
        return result;
    }

    public List<ResponseHeader> forPresentationManifest() {
        ArrayList<ResponseHeader> result = new ArrayList<ResponseHeader>();
        Optional.ofNullable(this.all).ifPresent(result::addAll);
        Optional.ofNullable(this.presentation.get("manifest")).ifPresent(result::addAll);
        return result;
    }

    public List<ResponseHeader> forPresentationCollection() {
        ArrayList<ResponseHeader> result = new ArrayList<ResponseHeader>();
        Optional.ofNullable(this.all).ifPresent(result::addAll);
        Optional.ofNullable(this.presentation.get("collection")).ifPresent(result::addAll);
        return result;
    }

    public List<ResponseHeader> forPresentationAnnotationList() {
        ArrayList<ResponseHeader> result = new ArrayList<ResponseHeader>();
        Optional.ofNullable(this.all).ifPresent(result::addAll);
        Optional.ofNullable(this.presentation.get("annotationList")).ifPresent(result::addAll);
        return result;
    }

    public static class ResponseHeader {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

