/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.image.frontend;

import de.digitalcollections.commons.springboot.metrics.MetricsService;
import de.digitalcollections.iiif.hymir.config.CustomResponseHeaders;
import de.digitalcollections.iiif.hymir.image.business.api.ImageService;
import de.digitalcollections.iiif.hymir.model.exception.InvalidParametersException;
import de.digitalcollections.iiif.hymir.model.exception.UnsupportedFormatException;
import de.digitalcollections.iiif.hymir.util.UrlRules;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.ImageApiSelector;
import de.digitalcollections.iiif.model.image.ResolvingException;
import de.digitalcollections.iiif.model.jackson.IiifObjectMapper;
import de.digitalcollections.model.api.identifiable.resource.exceptions.ResourceNotFoundException;
import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.WebRequest;

@Controller
@RequestMapping(value={"${custom.iiif.image.urlPrefix:/image/v2/}"})
public class IIIFImageApiController {
    public static final String VERSION = "v2";
    @Value(value="${custom.iiif.image.canonicalRedirect:true}")
    private boolean isCanonicalRedirectEnabled;
    protected final CustomResponseHeaders customResponseHeaders;
    private final ImageService imageService;
    private final IiifObjectMapper objectMapper;
    private final MetricsService metricsService;

    @Autowired
    public IIIFImageApiController(ImageService imageService, IiifObjectMapper objectMapper, CustomResponseHeaders customResponseHeaders, MetricsService metricsService) {
        this.imageService = imageService;
        this.objectMapper = objectMapper;
        this.customResponseHeaders = customResponseHeaders;
        this.metricsService = metricsService;
    }

    void setCanonicalRedirectEnabled(boolean canonicalRedirectEnabled) {
        this.isCanonicalRedirectEnabled = canonicalRedirectEnabled;
    }

    private String getUrlBase(HttpServletRequest request) {
        String host;
        String scheme = request.getHeader("X-Forwarded-Proto");
        if (scheme == null) {
            scheme = request.getScheme();
        }
        if ((host = request.getHeader("X-Forwarded-Host")) == null) {
            host = request.getHeader("Host");
        }
        if (host == null) {
            host = request.getRemoteHost();
        }
        Object base = String.format("%s://%s", scheme, host);
        if (!request.getContextPath().isEmpty()) {
            base = (String)base + request.getContextPath();
        }
        return base;
    }

    @RequestMapping(value={"{identifier}/{region}/{size}/{rotation}/{quality}.{format}"})
    public ResponseEntity<byte[]> getImageRepresentation(@PathVariable String identifier, @PathVariable String region, @PathVariable String size, @PathVariable String rotation, @PathVariable String quality, @PathVariable String format, HttpServletRequest request, HttpServletResponse response, WebRequest webRequest) throws UnsupportedFormatException, UnsupportedOperationException, IOException, InvalidParametersException, ResourceNotFoundException {
        String canonicalForm;
        if (UrlRules.isInsecure(identifier)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)new byte[0]);
        }
        HttpHeaders headers = new HttpHeaders();
        String path = request.getPathInfo() != null ? request.getPathInfo() : request.getServletPath();
        long modified = this.imageService.getImageModificationDate(identifier).toEpochMilli();
        webRequest.checkNotModified(modified);
        headers.setDate("Last-Modified", modified);
        ImageApiSelector selector = new ImageApiSelector();
        try {
            selector.setIdentifier(identifier);
            selector.setRegion(region);
            selector.setSize(size);
            selector.setRotation(rotation);
            if (quality.equals("native")) {
                quality = "default";
            }
            selector.setQuality(ImageApiProfile.Quality.valueOf((String)quality.toUpperCase()));
            selector.setFormat(ImageApiProfile.Format.valueOf((String)format.toUpperCase()));
        }
        catch (ResolvingException e) {
            throw new InvalidParametersException((Exception)((Object)e));
        }
        de.digitalcollections.iiif.model.image.ImageService info = new de.digitalcollections.iiif.model.image.ImageService("http://foo.org/" + identifier);
        this.imageService.readImageInfo(identifier, info);
        ImageApiProfile profile = ImageApiProfile.merge((List)info.getProfiles());
        try {
            canonicalForm = selector.getCanonicalForm(new Dimension(info.getWidth(), info.getHeight()), profile, ImageApiProfile.Quality.COLOR);
        }
        catch (ResolvingException e) {
            throw new InvalidParametersException((Exception)((Object)e));
        }
        String canonicalUrl = this.getUrlBase(request) + path.substring(0, path.indexOf(identifier)) + canonicalForm;
        if (this.isCanonicalRedirectEnabled && !canonicalForm.equals(selector.toString())) {
            response.setHeader("Link", String.format("<%s>;rel=\"canonical\"", canonicalUrl));
            response.sendRedirect(canonicalUrl);
            return null;
        }
        headers.add("Link", String.format("<%s>;rel=\"canonical\"", canonicalUrl));
        String filename = path.replaceFirst("/image/", "").replace('/', '_').replace(',', '_');
        headers.set("Content-Disposition", "inline; filename=" + filename);
        headers.add("Link", String.format("<%s>;rel=\"profile\"", ((Profile)info.getProfiles().get(0)).getIdentifier().toString()));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        long duration = System.currentTimeMillis();
        this.imageService.processImage(identifier, selector, profile, os);
        duration = System.currentTimeMillis() - duration;
        this.metricsService.increaseCounterWithDurationAndPercentiles("image", "process", Long.valueOf(duration));
        this.customResponseHeaders.forImageTile().forEach(customResponseHeader -> headers.set(customResponseHeader.getName(), customResponseHeader.getValue()));
        String mimeType = selector.getFormat().getMimeType().getTypeName();
        headers.setContentType(MediaType.parseMediaType((String)mimeType));
        return new ResponseEntity((Object)os.toByteArray(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"{identifier}/info.json"}, method={RequestMethod.GET, RequestMethod.HEAD})
    public ResponseEntity<String> getInfo(@PathVariable String identifier, HttpServletRequest req, WebRequest webRequest) throws Exception {
        if (UrlRules.isInsecure(identifier)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"");
        }
        long duration = System.currentTimeMillis();
        long modified = this.imageService.getImageModificationDate(identifier).toEpochMilli();
        webRequest.checkNotModified(modified);
        String path = req.getPathInfo() != null ? req.getPathInfo() : req.getServletPath();
        String baseUrl = this.getUrlBase(req);
        String imageIdentifier = baseUrl + path.replace("/info.json", "").replace(identifier, URLEncoder.encode(identifier, StandardCharsets.UTF_8));
        de.digitalcollections.iiif.model.image.ImageService info = new de.digitalcollections.iiif.model.image.ImageService(imageIdentifier);
        this.imageService.readImageInfo(identifier, info);
        duration = System.currentTimeMillis() - duration;
        this.metricsService.increaseCounterWithDurationAndPercentiles("generations", "infojson", Long.valueOf(duration));
        HttpHeaders headers = new HttpHeaders();
        headers.setDate("Last-Modified", modified);
        String contentType = req.getHeader("Accept");
        if (contentType != null && contentType.equals("application/ld+json")) {
            headers.set("Content-Type", contentType);
        } else {
            headers.set("Content-Type", "application/json");
            headers.add("Link", "<http://iiif.io/api/image/2/context.json>; rel=\"http://www.w3.org/ns/json-ld#context\"; type=\"application/ld+json\"");
        }
        headers.add("Link", String.format("<%s>;rel=\"profile\"", ((Profile)info.getProfiles().get(0)).getIdentifier().toString()));
        headers.add("Access-Control-Allow-Origin", "*");
        this.customResponseHeaders.forImageInfo().forEach(customResponseHeader -> headers.set(customResponseHeader.getName(), customResponseHeader.getValue()));
        return new ResponseEntity((Object)this.objectMapper.writeValueAsString((Object)info), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"{identifier}"}, method={RequestMethod.GET, RequestMethod.HEAD})
    public String getInfoRedirect(@PathVariable String identifier, HttpServletResponse response) {
        if (UrlRules.isInsecure(identifier)) {
            response.setStatus(400);
            return null;
        }
        response.setHeader("Access-Control-Allow-Origin", "*");
        return "redirect:/image/v2/" + identifier + "/info.json";
    }
}

