/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.image.business;

import com.google.common.collect.Streams;
import de.digitalcollections.commons.file.business.impl.resolved.ResolvedFileResourceServiceImpl;
import de.digitalcollections.iiif.hymir.image.business.ImageServiceImpl;
import de.digitalcollections.iiif.hymir.image.business.api.ImageSecurityService;
import de.digitalcollections.iiif.hymir.image.business.api.ImageService;
import de.digitalcollections.iiif.hymir.model.exception.InvalidParametersException;
import de.digitalcollections.iiif.hymir.model.exception.UnsupportedFormatException;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.ImageApiSelector;
import de.digitalcollections.iiif.model.image.ResolvingException;
import de.digitalcollections.iiif.model.image.Size;
import de.digitalcollections.iiif.model.image.TileInfo;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.MimeType;
import de.digitalcollections.model.api.identifiable.resource.exceptions.ResourceIOException;
import de.digitalcollections.model.api.identifiable.resource.exceptions.ResourceNotFoundException;
import de.digitalcollections.turbojpeg.imageio.TurboJpegImageReadParam;
import de.digitalcollections.turbojpeg.imageio.TurboJpegImageReader;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneOffset;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.imgscalr.Scalr;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ImageServiceImpl
implements ImageService {
    private final ImageSecurityService imageSecurityService;
    private final ResolvedFileResourceServiceImpl fileResourceService;
    @Value(value="${custom.iiif.logo:}")
    private String logoUrl;
    @Value(value="${custom.iiif.attribution:}")
    private String attribution;
    @Value(value="${custom.iiif.license:}")
    private String license;
    @Value(value="${custom.iiif.image.maxWidth:65500}")
    private int maxWidth;
    @Value(value="${custom.iiif.image.maxHeight:65500}")
    private int maxHeight;

    public ImageServiceImpl(@Autowired(required=false) ImageSecurityService imageSecurityService, @Autowired ResolvedFileResourceServiceImpl fileResourceService) {
        this.imageSecurityService = imageSecurityService;
        this.fileResourceService = fileResourceService;
    }

    private void enrichInfo(ImageReader reader, de.digitalcollections.iiif.model.image.ImageService info) throws IOException {
        ImageApiProfile profile = new ImageApiProfile();
        profile.addFeature(ImageApiProfile.Feature.PROFILE_LINK_HEADER, new ImageApiProfile.Feature[]{ImageApiProfile.Feature.CANONICAL_LINK_HEADER, ImageApiProfile.Feature.REGION_SQUARE, ImageApiProfile.Feature.ROTATION_BY_90S, ImageApiProfile.Feature.MIRRORING, ImageApiProfile.Feature.SIZE_ABOVE_FULL});
        profile.addFormat(ImageApiProfile.Format.GIF, new ImageApiProfile.Format[0]);
        if (reader.getHeight(0) > this.maxHeight || reader.getWidth(0) > this.maxWidth) {
            profile.setMaxWidth(Integer.valueOf(this.maxWidth));
            if (this.maxHeight != this.maxWidth) {
                profile.setMaxHeight(Integer.valueOf(this.maxHeight));
            }
        }
        info.addProfile((Profile)ImageApiProfile.LEVEL_TWO, new Profile[]{profile});
        info.setWidth(Integer.valueOf(reader.getWidth(0)));
        info.setHeight(Integer.valueOf(reader.getHeight(0)));
        int numImages = reader.getNumImages(true);
        if (numImages > 1) {
            for (int i = 0; i < numImages; ++i) {
                int width = reader.getWidth(i);
                int height = reader.getHeight(i);
                if (width <= 1 || height <= 1 || width > this.maxWidth || height > this.maxHeight) continue;
                info.addSize(new Size(reader.getWidth(i), reader.getHeight(i)), new Size[0]);
            }
        }
        if (reader.isImageTiled(0)) {
            int width = reader.getTileWidth(0);
            TileInfo tileInfo = new TileInfo(Integer.valueOf(width));
            for (int i = 0; i < numImages; ++i) {
                int scaledWidth = reader.getTileWidth(i);
                tileInfo.addScaleFactor(Integer.valueOf(width / scaledWidth), new Integer[0]);
            }
            info.addTile(tileInfo, new TileInfo[0]);
        } else if (reader instanceof TurboJpegImageReader) {
            if (reader.getWidth(0) >= 512 && reader.getHeight(0) >= 512) {
                TileInfo ti = new TileInfo(Integer.valueOf(512));
                ti.addScaleFactor(Integer.valueOf(1), new Integer[]{2, 4, 8, 16});
                info.addTile(ti, new TileInfo[0]);
            }
            if (reader.getWidth(0) >= 1024 && reader.getHeight(0) >= 1024) {
                TileInfo ti = new TileInfo(Integer.valueOf(1024));
                ti.addScaleFactor(Integer.valueOf(1), new Integer[]{2, 4, 8, 16});
                info.addTile(ti, new TileInfo[0]);
            }
        }
    }

    private ImageReader getReader(String identifier) throws ResourceNotFoundException, UnsupportedFormatException, IOException {
        FileResource fileResource;
        if (this.imageSecurityService != null && !this.imageSecurityService.isAccessAllowed(identifier)) {
            throw new ResourceNotFoundException();
        }
        try {
            fileResource = this.fileResourceService.find(identifier, MimeType.MIME_IMAGE);
        }
        catch (ResourceIOException e) {
            throw new ResourceNotFoundException();
        }
        ImageInputStream iis = ImageIO.createImageInputStream(this.fileResourceService.getInputStream(fileResource));
        ImageReader reader = (ImageReader)Streams.stream(ImageIO.getImageReaders(iis)).findFirst().orElseThrow(UnsupportedFormatException::new);
        reader.setInput(iis);
        return reader;
    }

    public void readImageInfo(String identifier, de.digitalcollections.iiif.model.image.ImageService info) throws UnsupportedFormatException, UnsupportedOperationException, ResourceNotFoundException, IOException {
        URI license;
        this.enrichInfo(this.getReader(identifier), info);
        if (!this.logoUrl.isEmpty()) {
            info.addLogo(this.logoUrl, new String[0]);
        }
        if (!this.attribution.isEmpty()) {
            info.addAttribution(this.attribution, new String[0]);
        }
        if (!this.license.isEmpty()) {
            info.addLicense(this.license, new String[0]);
        } else if (this.imageSecurityService != null && (license = this.imageSecurityService.getLicense(identifier)) != null) {
            info.addLicense(license.toString(), new String[0]);
        }
    }

    private ImageReadParam getReadParam(ImageReader reader, ImageApiSelector selector, double decodeScaleFactor) throws IOException, InvalidParametersException {
        Rectangle targetRegion;
        ImageReadParam readParam = reader.getDefaultReadParam();
        Dimension nativeDimensions = new Dimension(reader.getWidth(0), reader.getHeight(0));
        try {
            targetRegion = selector.getRegion().resolve(nativeDimensions);
        }
        catch (ResolvingException e) {
            throw new InvalidParametersException((Exception)((Object)e));
        }
        Rectangle decodeRegion = new Rectangle((int)Math.ceil(targetRegion.getX() * decodeScaleFactor), (int)Math.ceil(targetRegion.getY() * decodeScaleFactor), (int)Math.ceil(targetRegion.getWidth() * decodeScaleFactor), (int)Math.ceil(targetRegion.getHeight() * decodeScaleFactor));
        readParam.setSourceRegion(decodeRegion);
        if (selector.getRotation().getRotation() != 0.0 && reader instanceof TurboJpegImageReader) {
            ((TurboJpegImageReadParam)readParam).setRotationDegree((int)selector.getRotation().getRotation());
        }
        return readParam;
    }

    private DecodedImage readImage(String identifier, ImageApiSelector selector, ImageApiProfile profile) throws IOException, ResourceNotFoundException, UnsupportedFormatException, InvalidParametersException {
        Dimension targetSize;
        Rectangle targetRegion;
        ImageReader reader = this.getReader(identifier);
        if (selector.getRotation().getRotation() % 90.0 != 0.0) {
            throw new UnsupportedOperationException("Can only rotate by multiples of 90 degrees.");
        }
        Dimension nativeDimensions = new Dimension(reader.getWidth(0), reader.getHeight(0));
        try {
            targetRegion = selector.getRegion().resolve(nativeDimensions);
        }
        catch (ResolvingException e) {
            throw new InvalidParametersException((Exception)((Object)e));
        }
        Dimension croppedDimensions = new Dimension(targetRegion.width, targetRegion.height);
        try {
            targetSize = selector.getSize().resolve(croppedDimensions, profile);
        }
        catch (ResolvingException e) {
            throw new InvalidParametersException((Exception)((Object)e));
        }
        double targetScaleFactor = (double)targetSize.width / targetRegion.getWidth();
        double decodeScaleFactor = 1.0;
        int imageIndex = 0;
        for (int idx = 0; idx < reader.getNumImages(true); ++idx) {
            double factor = (double)reader.getWidth(idx) / (double)nativeDimensions.width;
            if (factor < targetScaleFactor || !(Math.abs(targetScaleFactor - factor) < Math.abs(targetScaleFactor - decodeScaleFactor))) continue;
            decodeScaleFactor = factor;
            imageIndex = idx;
        }
        ImageReadParam readParam = this.getReadParam(reader, selector, decodeScaleFactor);
        int rotation = (int)selector.getRotation().getRotation();
        if (readParam instanceof TurboJpegImageReadParam && ((TurboJpegImageReadParam)readParam).getRotationDegree() != 0) {
            if (rotation == 90 || rotation == 270) {
                int w = targetSize.width;
                targetSize.width = targetSize.height;
                targetSize.height = w;
            }
            rotation = 0;
        }
        return new DecodedImage(reader.read(imageIndex, readParam), targetSize, rotation);
    }

    private BufferedImage transformImage(BufferedImage inputImage, Dimension targetSize, int rotation, boolean mirror, ImageApiProfile.Quality quality) {
        int outType;
        boolean needsAdditionalScaling;
        BufferedImage img = inputImage;
        int inType = img.getType();
        boolean bl = needsAdditionalScaling = !new Dimension(img.getWidth(), img.getHeight()).equals(targetSize);
        if (needsAdditionalScaling) {
            img = Scalr.resize((BufferedImage)img, (Scalr.Method)Scalr.Method.BALANCED, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetSize.width, (int)targetSize.height, (BufferedImageOp[])new BufferedImageOp[0]);
        }
        if (rotation != 0) {
            Scalr.Rotation rot;
            switch (rotation) {
                case 90: {
                    rot = Scalr.Rotation.CW_90;
                    break;
                }
                case 180: {
                    rot = Scalr.Rotation.CW_180;
                    break;
                }
                case 270: {
                    rot = Scalr.Rotation.CW_270;
                    break;
                }
                default: {
                    rot = null;
                }
            }
            img = Scalr.rotate((BufferedImage)img, (Scalr.Rotation)rot, (BufferedImageOp[])new BufferedImageOp[0]);
        }
        if (mirror) {
            img = Scalr.rotate((BufferedImage)img, (Scalr.Rotation)Scalr.Rotation.FLIP_HORZ, (BufferedImageOp[])new BufferedImageOp[0]);
        }
        switch (1.$SwitchMap$de$digitalcollections$iiif$model$image$ImageApiProfile$Quality[quality.ordinal()]) {
            case 1: {
                outType = 10;
                break;
            }
            case 2: {
                outType = 12;
                break;
            }
            case 3: {
                outType = 5;
                break;
            }
            default: {
                outType = inType;
            }
        }
        if (outType != img.getType()) {
            BufferedImage newImg = new BufferedImage(img.getWidth(), img.getHeight(), outType);
            Graphics2D g2d = newImg.createGraphics();
            g2d.drawImage((Image)img, 0, 0, null);
            img = newImg;
            g2d.dispose();
        }
        return img;
    }

    public void processImage(String identifier, ImageApiSelector selector, ImageApiProfile profile, OutputStream os) throws InvalidParametersException, UnsupportedOperationException, UnsupportedFormatException, ResourceNotFoundException, IOException {
        DecodedImage img = this.readImage(identifier, selector, profile);
        BufferedImage outImg = this.transformImage(img.img, img.targetSize, img.rotation, selector.getRotation().isMirror(), selector.getQuality());
        ImageWriter writer = (ImageWriter)Streams.stream(ImageIO.getImageWriters(new ImageTypeSpecifier(outImg), selector.getFormat().name())).findFirst().orElseThrow(UnsupportedFormatException::new);
        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
        writer.setOutput(ios);
        writer.write(null, new IIOImage(outImg, null, null), null);
        writer.dispose();
        ios.flush();
    }

    public Instant getImageModificationDate(String identifier) throws ResourceNotFoundException {
        if (this.imageSecurityService != null && !this.imageSecurityService.isAccessAllowed(identifier)) {
            throw new ResourceNotFoundException();
        }
        try {
            FileResource res = this.fileResourceService.find(identifier, MimeType.MIME_IMAGE);
            return res.getLastModified().toInstant(ZoneOffset.UTC);
        }
        catch (ResourceIOException e) {
            throw new ResourceNotFoundException();
        }
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }
}

