/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"de.digitalcollections.commons.file.config"})
public class SpringConfigBackendImage {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfigBackendImage.class);

    private static void deregisterSunImageSpis() {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        HashSet<String> spis = new HashSet<String>(Arrays.asList("com.sun.imageio.plugins.tiff.TIFFImageReaderSpi", "com.sun.imageio.plugins.tiff.TIFFImageWriterSpi", "com.sun.imageio.plugins.jpeg.JPEGImageReaderSpi", "com.sun.imageio.plugins.jpeg.JPEGImageWriterSpi", "com.sun.imageio.plugins.bmp.BMPImageReaderSpi", "com.sun.imageio.plugins.bmp.BMPImageWriterSpi"));
        for (String spi : spis) {
            try {
                Object spiProvider = registry.getServiceProviderByClass(Class.forName(spi));
                registry.deregisterServiceProvider(spiProvider);
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug(e.getMessage());
            }
        }
    }

    static {
        ImageIO.setUseCache(false);
        SpringConfigBackendImage.deregisterSunImageSpis();
        CharSequence[] readerMimeTypes = ImageIO.getReaderMIMETypes();
        LOGGER.info("ImageIO supported formats (reader): {}", (Object)String.join((CharSequence)",", readerMimeTypes));
        for (CharSequence mimeType : readerMimeTypes) {
            Iterator<ImageReader> imageReaders;
            Iterator<ImageReader> iterator = imageReaders = ImageIO.getImageReadersByMIMEType((String)mimeType);
            while (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                if (imageReader == null) continue;
                LOGGER.info("ImageReader: {} {}", (Object)mimeType, (Object)imageReader.getClass().toString());
            }
        }
        CharSequence[] writerMimeTypes = ImageIO.getWriterMIMETypes();
        LOGGER.info("ImageIO supported formats (writer): {}", (Object)String.join((CharSequence)",", writerMimeTypes));
        for (CharSequence writerMimeType : writerMimeTypes) {
            Iterator<ImageWriter> imageWriters;
            Iterator<ImageWriter> iterator = imageWriters = ImageIO.getImageWritersByMIMEType((String)writerMimeType);
            while (iterator.hasNext()) {
                ImageWriter imageWriter = iterator.next();
                if (imageWriter == null) continue;
                LOGGER.info("ImageWriter: {} {}", (Object)writerMimeType, (Object)imageWriter.getClass().toString());
            }
        }
    }
}

