/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.info.InfoEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
public class SpringConfigSecurity
extends WebSecurityConfigurerAdapter {
    @Value(value="${spring.security.user.name}")
    private String actuatorUsername;
    @Value(value="${spring.security.user.password}")
    private String actuatorPassword;
    @Value(value="${javamelody.init-parameters.monitoring-path:/monitoring}")
    private String javamelodyMonitoringPath;

    @Bean
    public HttpFirewall looseFirewall() {
        DefaultHttpFirewall firewall = new DefaultHttpFirewall();
        firewall.setAllowUrlEncodedSlash(true);
        return firewall;
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        ((InMemoryUserDetailsManagerConfigurer)auth.inMemoryAuthentication().passwordEncoder(this.passwordEncoderDummy())).withUser(User.withUsername((String)this.actuatorUsername).password(this.actuatorPassword).roles(new String[]{"ACTUATOR"}));
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/monitoring/**").authorizeRequests().requestMatchers(new RequestMatcher[]{EndpointRequest.to((Class[])new Class[]{InfoEndpoint.class, HealthEndpoint.class})})).permitAll().requestMatchers(new RequestMatcher[]{EndpointRequest.to((String[])new String[]{"jolokia", "prometheus", "version"})})).permitAll().requestMatchers(new RequestMatcher[]{EndpointRequest.toAnyEndpoint()})).hasRole("ACTUATOR").and()).httpBasic();
    }

    public void configure(WebSecurity web) throws Exception {
        web.httpFirewall(this.looseFirewall());
        web.ignoring().antMatchers(new String[]{this.javamelodyMonitoringPath});
    }

    private PasswordEncoder passwordEncoderDummy() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

