/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.config;

import de.digitalcollections.commons.springmvc.interceptors.CurrentUrlAsModelAttributeHandlerInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.springframework.web.util.UrlPathHelper;
import org.yaml.snakeyaml.Yaml;

@Configuration
public class SpringConfigWeb
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        localeChangeInterceptor.setParamName("language");
        registry.addInterceptor((HandlerInterceptor)localeChangeInterceptor);
        CurrentUrlAsModelAttributeHandlerInterceptor currentUrlAsModelAttributeHandlerInterceptor = new CurrentUrlAsModelAttributeHandlerInterceptor();
        currentUrlAsModelAttributeHandlerInterceptor.deleteParams(new String[]{"language"});
        registry.addInterceptor((HandlerInterceptor)currentUrlAsModelAttributeHandlerInterceptor);
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        UrlPathHelper urlPathHelper = new UrlPathHelper();
        urlPathHelper.setUrlDecode(false);
        configurer.setUrlPathHelper(urlPathHelper);
    }

    @Bean
    public LocaleResolver localeResolver() {
        return new SessionLocaleResolver();
    }

    @Bean
    public Map<String, String> iiifVersions() {
        Map versions;
        InputStream in;
        Yaml yaml = new Yaml();
        try {
            in = this.getClass().getResourceAsStream("/iiif-versions.yml");
            try {
                versions = (Map)yaml.load(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException exception) {
            throw new IllegalStateException(exception);
        }
        try {
            in = this.getClass().getResourceAsStream("/iiif-versions-custom.yml");
            try {
                Map customVersions = (Map)yaml.load(in);
                if (customVersions != null) {
                    customVersions.forEach(versions::putIfAbsent);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException exception) {
            throw new IllegalStateException(exception);
        }
        return versions;
    }
}

