/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.presentation.business.api;

import de.digitalcollections.iiif.hymir.model.exception.InvalidDataException;
import de.digitalcollections.iiif.hymir.model.exception.ResolvingException;
import de.digitalcollections.iiif.model.sharedcanvas.Canvas;
import de.digitalcollections.iiif.model.sharedcanvas.Collection;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import de.digitalcollections.iiif.model.sharedcanvas.Range;
import de.digitalcollections.iiif.model.sharedcanvas.Sequence;
import java.net.URI;
import java.time.Instant;

public interface PresentationService {
    public Collection getCollection(String var1) throws ResolvingException, InvalidDataException;

    public Manifest getManifest(String var1) throws ResolvingException, InvalidDataException;

    default public Instant getManifestModificationDate(String identifier) throws ResolvingException {
        return Instant.now();
    }

    default public Instant getCollectionModificationDate(String identifier) throws ResolvingException {
        return Instant.now();
    }

    default public Canvas getCanvas(String manifestId, String canvasUri) throws ResolvingException, InvalidDataException {
        return this.getCanvas(manifestId, URI.create(canvasUri));
    }

    default public Canvas getCanvas(String manifestId, URI canvasUri) throws ResolvingException, InvalidDataException {
        return this.getManifest(manifestId).getSequences().stream().flatMap(seq -> seq.getCanvases().stream()).filter(canv -> canv.getIdentifier().equals(canvasUri)).findFirst().orElseThrow(ResolvingException::new);
    }

    default public Range getRange(String manifestId, String rangeUri) throws ResolvingException, InvalidDataException {
        return this.getRange(manifestId, URI.create(rangeUri));
    }

    default public Range getRange(String manifestId, URI rangeUri) throws ResolvingException, InvalidDataException {
        return this.getManifest(manifestId).getRanges().stream().filter(range -> range.getIdentifier().equals(rangeUri)).findFirst().orElseThrow(ResolvingException::new);
    }

    default public Sequence getSequence(String manifestId, String sequenceUri) throws ResolvingException, InvalidDataException {
        return this.getSequence(manifestId, URI.create(sequenceUri));
    }

    default public Sequence getSequence(String manifestId, URI sequenceUri) throws ResolvingException, InvalidDataException {
        return this.getManifest(manifestId).getSequences().stream().filter(seq -> seq.getIdentifier().equals(sequenceUri)).findFirst().orElseThrow(ResolvingException::new);
    }
}

