/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.cli;

import de.digitalcollections.iiif.hymir.cli.CliException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Cli {
    private final PrintWriter out;
    private String rulesPath = null;
    private int exitStatus = -1;
    private String springProfiles = null;

    public Cli(PrintWriter out, String ... args) throws ParseException, CliException {
        this.out = out;
        Options options = new Options();
        options.addOption("h", "help", false, "Show help");
        options.addOption("r", "rulesPath", true, "The resolving rulesPath to map names to images or manifests");
        options.addOption("p", "spring.profiles.active", true, "The active spring configuration");
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("help")) {
            this.showHelp(options);
            this.exitStatus = 0;
            return;
        }
        if (cmd.hasOption("rulesPath")) {
            this.rulesPath = cmd.getOptionValue("rulesPath");
            this.validateRulesPath();
        }
        if (cmd.hasOption("spring.profiles.active")) {
            this.springProfiles = cmd.getOptionValue("spring.profiles.active");
        }
    }

    private void validateRulesPath() throws CliException {
        if (this.rulesPath.contains(":")) {
            try {
                URL url = new URL(this.rulesPath);
                url.getContent();
            }
            catch (MalformedURLException e) {
                throw new CliException("Cannot parse URL: " + this.rulesPath);
            }
            catch (IOException e) {
                throw new CliException("Rules configuration not found: " + this.rulesPath);
            }
        } else {
            File rulesFile = new File(this.rulesPath);
            if (!rulesFile.exists()) {
                throw new CliException("Rules configuration not found: " + this.rulesPath);
            }
        }
    }

    public boolean hasRulesPath() {
        return this.rulesPath != null;
    }

    public String getRulesPath() {
        return this.rulesPath;
    }

    public boolean hasExitStatus() {
        return this.exitStatus > -1;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    private void showHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.out, 120, "java -jar hymir-<version>-exec.jar", null, options, 2, 8, null, true);
        this.out.flush();
    }

    public boolean hasSpringProfiles() {
        return this.springProfiles != null;
    }

    public String getSpringProfiles() {
        return this.springProfiles;
    }
}

