/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.image.frontend;

import de.digitalcollections.iiif.hymir.image.business.api.ImageService;
import de.digitalcollections.iiif.hymir.model.exception.InvalidParametersException;
import de.digitalcollections.iiif.hymir.model.exception.ResourceNotFoundException;
import de.digitalcollections.iiif.hymir.model.exception.UnsupportedFormatException;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.ImageApiSelector;
import de.digitalcollections.iiif.model.jackson.IiifObjectMapper;
import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.WebRequest;

@Controller
@RequestMapping(value={"/image/v2/"})
public class IIIFImageApiController {
    public static final String VERSION = "v2";
    @Autowired
    private ImageService imageService;
    @Autowired
    private IiifObjectMapper objectMapper;

    private String getUrlBase(HttpServletRequest request) {
        String host;
        String scheme = request.getHeader("X-Forwarded-Proto");
        if (scheme == null) {
            scheme = request.getScheme();
        }
        if ((host = request.getHeader("X-Forwarded-Host")) == null) {
            host = request.getHeader("Host");
        }
        if (host == null) {
            host = request.getRemoteHost();
        }
        String base = String.format("%s://%s", scheme, host);
        if (!request.getContextPath().isEmpty()) {
            base = base + request.getContextPath();
        }
        return base;
    }

    @RequestMapping(value={"{identifier}/{region}/{size}/{rotation}/{quality}.{format}"})
    public ResponseEntity<byte[]> getImageRepresentation(@PathVariable String identifier, @PathVariable String region, @PathVariable String size, @PathVariable String rotation, @PathVariable String quality, @PathVariable String format, HttpServletRequest request, HttpServletResponse response, WebRequest webRequest) throws UnsupportedFormatException, UnsupportedOperationException, IOException, InvalidParametersException, ResourceNotFoundException {
        String canonicalForm;
        HttpHeaders headers = new HttpHeaders();
        String path = request.getPathInfo() != null ? request.getPathInfo() : request.getServletPath();
        long modified = this.imageService.getImageModificationDate(identifier).toEpochMilli();
        webRequest.checkNotModified(modified);
        headers.setDate("Last-Modified", modified);
        ImageApiSelector selector = new ImageApiSelector();
        try {
            selector.setIdentifier(identifier);
            selector.setRegion(region);
            selector.setSize(size);
            selector.setRotation(rotation);
            if (quality.equals("native")) {
                quality = "default";
            }
            selector.setQuality(ImageApiProfile.Quality.valueOf((String)quality.toUpperCase()));
            selector.setFormat(ImageApiProfile.Format.valueOf((String)format.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParametersException(e.getMessage());
        }
        de.digitalcollections.iiif.model.image.ImageService info = new de.digitalcollections.iiif.model.image.ImageService("http://foo.org/" + identifier);
        this.imageService.readImageInfo(identifier, info);
        try {
            canonicalForm = selector.getCanonicalForm(new Dimension(info.getWidth(), info.getHeight()), ImageApiProfile.LEVEL_TWO, ImageApiProfile.Quality.COLOR);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParametersException(e.getMessage());
        }
        String canonicalUrl = this.getUrlBase(request) + path.substring(0, path.indexOf(identifier)) + canonicalForm;
        if (!canonicalForm.equals(selector.toString())) {
            response.setHeader("Link", String.format("<%s>;rel=\"canonical\"", canonicalUrl));
            response.sendRedirect(canonicalUrl);
            return null;
        }
        headers.add("Link", String.format("<%s>;rel=\"canonical\"", canonicalUrl));
        String mimeType = selector.getFormat().getMimeType().getTypeName();
        headers.setContentType(MediaType.parseMediaType((String)mimeType));
        String filename = path.replaceFirst("/image/", "").replace('/', '_').replace(',', '_');
        headers.set("Content-Disposition", "inline; filename=" + filename);
        headers.add("Link", String.format("<%s>;rel=\"profile\"", ((Profile)info.getProfiles().get(0)).getIdentifier().toString()));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.imageService.processImage(identifier, selector, (OutputStream)os);
        return new ResponseEntity((Object)os.toByteArray(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"{identifier}/info.json"}, method={RequestMethod.GET, RequestMethod.HEAD})
    public ResponseEntity<String> getInfo(@PathVariable String identifier, HttpServletRequest req, WebRequest webRequest) throws Exception {
        identifier = URLDecoder.decode(identifier, "UTF-8");
        long modified = this.imageService.getImageModificationDate(identifier).toEpochMilli();
        webRequest.checkNotModified(modified);
        String path = req.getPathInfo() != null ? req.getPathInfo() : req.getServletPath();
        String baseUrl = this.getUrlBase(req);
        de.digitalcollections.iiif.model.image.ImageService info = new de.digitalcollections.iiif.model.image.ImageService(baseUrl + path.replace("/info.json", ""));
        this.imageService.readImageInfo(identifier, info);
        HttpHeaders headers = new HttpHeaders();
        headers.setDate("Last-Modified", modified);
        String contentType = req.getHeader("Accept");
        if (contentType != null && contentType.equals("application/ld+json")) {
            headers.set("Content-Type", contentType);
        } else {
            headers.set("Content-Type", "application/json");
            headers.add("Link", "<http://iiif.io/api/image/2/context.json>; rel=\"http://www.w3.org/ns/json-ld#context\"; type=\"application/ld+json\"");
        }
        headers.add("Link", String.format("<%s>;rel=\"profile\"", ((Profile)info.getProfiles().get(0)).getIdentifier().toString()));
        headers.add("Access-Control-Allow-Origin", "*");
        return new ResponseEntity((Object)this.objectMapper.writeValueAsString((Object)info), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"{identifier}"}, method={RequestMethod.GET, RequestMethod.HEAD})
    public String getInfoRedirect(@PathVariable String identifier, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        return "redirect:/image/v2/" + identifier + "/info.json";
    }
}

