/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.image.frontend.impl.springmvc.controller.v2;

import de.digitalcollections.iiif.hymir.image.business.api.service.v2.ImageService;
import de.digitalcollections.iiif.hymir.model.api.exception.InvalidParametersException;
import de.digitalcollections.iiif.hymir.model.api.exception.ResolvingException;
import de.digitalcollections.iiif.hymir.model.api.exception.ResourceNotFoundException;
import de.digitalcollections.iiif.hymir.model.api.exception.UnsupportedFormatException;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.ImageApiSelector;
import de.digitalcollections.iiif.model.jackson.IiifObjectMapper;
import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller(value="IIIFImageApiController-v2")
@RequestMapping(value={"/image/v2/"})
public class IIIFImageApiController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IIIFImageApiController.class);
    public static final String VERSION = "v2";
    @Autowired
    private ImageService imageService;
    @Autowired
    private IiifObjectMapper objectMapper;

    private String getUrlBase(HttpServletRequest request) {
        String host;
        String requestURI = request.getRequestURI();
        String scheme = request.getHeader("X-Forwarded-Proto");
        if (scheme == null) {
            scheme = request.getScheme();
        }
        if ((host = request.getHeader("X-Forwarded-Host")) == null) {
            host = request.getHeader("Host");
        }
        String base = String.format("%s://%s", scheme, host);
        if (!request.getContextPath().isEmpty()) {
            base = base + request.getContextPath();
        }
        return base;
    }

    @CrossOrigin(allowedHeaders={"*"}, origins={"*"})
    @RequestMapping(value={"{identifier}/{region}/{size}/{rotation}/{quality}.{format}"})
    public ResponseEntity<byte[]> getImageRepresentation(@PathVariable String identifier, @PathVariable String region, @PathVariable String size, @PathVariable String rotation, @PathVariable String quality, @PathVariable String format, HttpServletRequest request, HttpServletResponse response) throws ResolvingException, UnsupportedFormatException, UnsupportedOperationException, IOException, URISyntaxException, InvalidParametersException, ResourceNotFoundException {
        HttpHeaders headers = new HttpHeaders();
        String path = request.getPathInfo() != null ? request.getPathInfo() : request.getServletPath();
        ImageApiSelector selector = new ImageApiSelector();
        selector.setIdentifier(identifier);
        selector.setRegion(region);
        selector.setSize(size);
        selector.setRotation(rotation);
        if (quality.equals("native")) {
            quality = "default";
        }
        selector.setQuality(ImageApiProfile.Quality.valueOf((String)quality.toUpperCase()));
        selector.setFormat(ImageApiProfile.Format.valueOf((String)format.toUpperCase()));
        de.digitalcollections.iiif.model.image.ImageService info = new de.digitalcollections.iiif.model.image.ImageService("http://foo.org/" + identifier);
        this.imageService.readImageInfo(identifier, info);
        String canonicalForm = selector.getCanonicalForm(new Dimension(info.getWidth(), info.getHeight()), ImageApiProfile.LEVEL_TWO, ImageApiProfile.Quality.COLOR);
        if (!canonicalForm.equals(selector.toString())) {
            String canonicalUrl = this.getUrlBase(request) + path.substring(0, path.indexOf(identifier)) + canonicalForm;
            response.sendRedirect(canonicalUrl);
            return null;
        }
        String mimeType = selector.getFormat().getMimeType().getTypeName();
        headers.setContentType(MediaType.parseMediaType((String)mimeType));
        String filename = path.replaceFirst("/image/", "").replace('/', '_').replace(',', '_');
        headers.set("Content-Disposition", "inline; filename=" + filename);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.imageService.processImage(identifier, selector, os);
        return new ResponseEntity((Object)os.toByteArray(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"{identifier}"})
    public void redirectToInfo(@PathVariable String ident, HttpServletResponse response) throws IOException {
        response.sendRedirect("/" + ident + "/info.json");
    }

    @CrossOrigin(allowedHeaders={"*"}, origins={"*"})
    @RequestMapping(value={"{identifier}/info.json"}, method={RequestMethod.GET, RequestMethod.HEAD})
    public ResponseEntity<String> getInfo(@PathVariable String identifier, HttpServletRequest request) throws Exception {
        identifier = URLDecoder.decode(identifier, "UTF-8");
        String path = request.getPathInfo() != null ? request.getPathInfo() : request.getServletPath();
        String baseUrl = this.getUrlBase(request);
        de.digitalcollections.iiif.model.image.ImageService info = new de.digitalcollections.iiif.model.image.ImageService(baseUrl + path.replace("/info.json", ""));
        this.imageService.readImageInfo(identifier, info);
        HttpHeaders headers = new HttpHeaders();
        String contentType = request.getHeader("Accept");
        if (contentType != null && contentType.equals("application/ld+json")) {
            headers.set("Content-Type", contentType);
        } else {
            headers.set("Content-Type", "application/json");
            headers.add("Link", "<http://iiif.io/api/image/2/context.json>; rel=\"http://www.w3.org/ns/json-ld#context\"; type=\"application/ld+json\"");
        }
        headers.add("Link", String.format("<%s>;rel=\"profile\"", ((Profile)info.getProfiles().get(0)).getIdentifier().toString()));
        return new ResponseEntity((Object)this.objectMapper.writeValueAsString((Object)info), (MultiValueMap)headers, HttpStatus.OK);
    }

    @CrossOrigin(allowedHeaders={"*"}, origins={"*"})
    @RequestMapping(value={"{identifier}"}, method={RequestMethod.GET, RequestMethod.HEAD})
    public String getInfoRedirect(@PathVariable String identifier) {
        return "redirect:/image/v2/" + identifier + "/info.json";
    }
}

