/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.frontend.impl.springmvc.exception;

import de.digitalcollections.iiif.hymir.model.api.exception.InvalidParametersException;
import de.digitalcollections.iiif.hymir.model.api.exception.ResolvingException;
import de.digitalcollections.iiif.hymir.model.api.exception.ResourceNotFoundException;
import de.digitalcollections.iiif.hymir.model.api.exception.UnsupportedFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ExceptionAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionAdvice.class);

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={InvalidParametersException.class})
    public void handleInvalidParametersException(Exception exception) {
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ResolvingException.class})
    public void handleResolvingException(Exception exception) {
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ResourceNotFoundException.class})
    public void handleResourceNotFoundException(Exception exception) {
    }

    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    @ExceptionHandler(value={UnsupportedFormatException.class})
    public void handleUnsupportedFormatException(Exception exception) {
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={UnsupportedOperationException.class})
    public void handleUnsupportedOperationException(Exception exception) {
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public void handleAllOther(Exception exception) {
        LOGGER.error("exception stack trace", (Throwable)exception);
    }
}

