/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.presentation.backend.impl.repository.v2;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.digitalcollections.core.business.api.ResourceService;
import de.digitalcollections.core.model.api.MimeType;
import de.digitalcollections.core.model.api.resource.Resource;
import de.digitalcollections.core.model.api.resource.enums.ResourcePersistenceType;
import de.digitalcollections.core.model.api.resource.exceptions.ResourceIOException;
import de.digitalcollections.iiif.hymir.model.api.exception.InvalidDataException;
import de.digitalcollections.iiif.hymir.model.api.exception.ResolvingException;
import de.digitalcollections.iiif.hymir.presentation.backend.api.repository.v2.PresentationRepository;
import de.digitalcollections.iiif.model.jackson.IiifObjectMapper;
import de.digitalcollections.iiif.model.sharedcanvas.Collection;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="PresentationRepositoryImpl-v2.0.0")
public class PresentationRepositoryImpl
implements PresentationRepository {
    private static final String COLLECTION_PREFIX = "collection-";
    private static final Logger LOGGER = LoggerFactory.getLogger(PresentationRepositoryImpl.class);
    private final Cache<String, Object> httpCache = CacheBuilder.newBuilder().maximumSize(32L).build();
    @Autowired
    private IiifObjectMapper objectMapper;
    @Autowired
    private ResourceService resourceService;

    public Collection getCollection(String name) throws ResolvingException, InvalidDataException {
        Resource resource;
        String collectionName = COLLECTION_PREFIX + name;
        try {
            resource = this.resourceService.get(collectionName, ResourcePersistenceType.REFERENCED, MimeType.MIME_APPLICATION_JSON);
        }
        catch (ResourceIOException ex) {
            LOGGER.warn("Error getting collection for name " + collectionName, (Throwable)ex);
            throw new ResolvingException("No collection for name " + collectionName);
        }
        URI uri = resource.getUri();
        return this.getCollection(uri);
    }

    public Collection getCollection(URI collectionUri) throws ResolvingException, InvalidDataException {
        Collection collection;
        String location = collectionUri.toString();
        LOGGER.debug("Trying to get collection from " + location);
        String scheme = collectionUri.getScheme();
        if ("http".equals(scheme) && (collection = (Collection)this.httpCache.getIfPresent((Object)location)) != null) {
            LOGGER.debug("HTTP Cache hit for collection " + location);
            return collection;
        }
        String collectionJson = this.getResourceJson(collectionUri);
        try {
            collection = (Collection)this.objectMapper.readValue(collectionJson, Collection.class);
        }
        catch (IOException e) {
            throw new InvalidDataException("Error reading from JSON", (Exception)e);
        }
        if ("http".equals(scheme)) {
            this.httpCache.put((Object)location, (Object)collection);
        }
        return collection;
    }

    public Manifest getManifest(String identifier) throws ResolvingException, InvalidDataException {
        Resource resource;
        try {
            resource = this.resourceService.get(identifier, ResourcePersistenceType.REFERENCED, MimeType.MIME_APPLICATION_JSON);
        }
        catch (ResourceIOException ex) {
            LOGGER.warn("Error getting manifest for identifier " + identifier, (Throwable)ex);
            throw new ResolvingException("No manifest for identifier " + identifier);
        }
        URI uri = resource.getUri();
        return this.getManifest(uri);
    }

    public Manifest getManifest(URI manifestUri) throws ResolvingException, InvalidDataException {
        Manifest manifest;
        String location = manifestUri.toString();
        LOGGER.debug("Trying to get manifest from " + location);
        String scheme = manifestUri.getScheme();
        if ("http".equals(scheme) && (manifest = (Manifest)this.httpCache.getIfPresent((Object)location)) != null) {
            LOGGER.debug("HTTP Cache hit for manifest " + location);
            return manifest;
        }
        String manifestJson = this.getResourceJson(manifestUri);
        try {
            manifest = (Manifest)this.objectMapper.readValue(manifestJson, Manifest.class);
        }
        catch (IOException e) {
            throw new InvalidDataException("Could not read manifest JSON", (Exception)e);
        }
        if ("http".equals(scheme)) {
            this.httpCache.put((Object)location, (Object)manifest);
        }
        return manifest;
    }

    public String getResourceJson(URI resourceUri) throws ResolvingException {
        try {
            InputStream inputStream = this.resourceService.getInputStream(resourceUri);
            String json = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            inputStream.close();
            LOGGER.debug("DONE getResourceJson() for " + resourceUri.toString());
            return json;
        }
        catch (IOException e) {
            throw new ResolvingException((Throwable)e);
        }
    }

    public JSONObject getResourceAsJsonObject(URI resourceUri) throws ResolvingException, ParseException {
        String json = this.getResourceJson(resourceUri);
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(json);
        return (JSONObject)obj;
    }

    public JSONObject getResourceAsJsonObject(String resourceUri) throws ResolvingException, ParseException {
        return this.getResourceAsJsonObject(URI.create(resourceUri));
    }
}

