/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.image.business.impl.service.v2;

import com.google.common.collect.Streams;
import de.digitalcollections.core.business.api.ResourceService;
import de.digitalcollections.core.model.api.MimeType;
import de.digitalcollections.core.model.api.resource.Resource;
import de.digitalcollections.core.model.api.resource.enums.ResourcePersistenceType;
import de.digitalcollections.core.model.api.resource.exceptions.ResourceIOException;
import de.digitalcollections.iiif.hymir.image.business.api.service.ImageSecurityService;
import de.digitalcollections.iiif.hymir.image.business.api.service.v2.ImageService;
import de.digitalcollections.iiif.hymir.image.business.impl.service.v2.ImageServiceImpl;
import de.digitalcollections.iiif.hymir.model.api.exception.InvalidParametersException;
import de.digitalcollections.iiif.hymir.model.api.exception.ResourceNotFoundException;
import de.digitalcollections.iiif.hymir.model.api.exception.UnsupportedFormatException;
import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.image.ImageApiProfile;
import de.digitalcollections.iiif.model.image.ImageApiSelector;
import de.digitalcollections.iiif.model.image.Size;
import de.digitalcollections.iiif.model.image.TileInfo;
import de.digitalcollections.turbojpeg.imageio.TurboJpegImageReadParam;
import de.digitalcollections.turbojpeg.imageio.TurboJpegImageReader;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImageServiceImpl
implements ImageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageServiceImpl.class);
    @Autowired(required=false)
    private ImageSecurityService imageSecurityService;
    @Autowired
    private ResourceService resourceService;

    private void enrichInfo(ImageReader reader, de.digitalcollections.iiif.model.image.ImageService info) throws IOException {
        ImageApiProfile profile = new ImageApiProfile();
        profile.addFeature(ImageApiProfile.Feature.BASE_URI_REDIRECT, new ImageApiProfile.Feature[]{ImageApiProfile.Feature.CORS, ImageApiProfile.Feature.JSONLD_MEDIA_TYPE, ImageApiProfile.Feature.MIRRORING, ImageApiProfile.Feature.PROFILE_LINK_HEADER, ImageApiProfile.Feature.REGION_BY_PCT, ImageApiProfile.Feature.REGION_BY_PX, ImageApiProfile.Feature.REGION_SQUARE, ImageApiProfile.Feature.ROTATION_BY_90S, ImageApiProfile.Feature.SIZE_BY_CONFINED_WH, ImageApiProfile.Feature.SIZE_BY_H, ImageApiProfile.Feature.SIZE_BY_PCT, ImageApiProfile.Feature.SIZE_BY_W, ImageApiProfile.Feature.SIZE_BY_WH});
        info.addProfile((Profile)ImageApiProfile.LEVEL_TWO, new Profile[]{profile});
        info.setWidth(Integer.valueOf(reader.getWidth(0)));
        info.setHeight(Integer.valueOf(reader.getHeight(0)));
        int numImages = reader.getNumImages(true);
        if (numImages > 1) {
            for (int i = 0; i < numImages; ++i) {
                info.addSize(new Size(reader.getWidth(i), reader.getHeight(i)), new Size[0]);
            }
        }
        if (reader.isImageTiled(0)) {
            int width = reader.getTileWidth(0);
            TileInfo tileInfo = new TileInfo(Integer.valueOf(width));
            for (int i = 0; i < numImages; ++i) {
                int scaledWidth = reader.getTileWidth(i);
                tileInfo.addScaleFactor(Integer.valueOf(width / scaledWidth), new Integer[0]);
            }
            info.addTile(tileInfo, new TileInfo[0]);
        } else if (reader instanceof TurboJpegImageReader) {
            if (reader.getWidth(0) >= 512 && reader.getHeight(0) >= 512) {
                TileInfo ti = new TileInfo(Integer.valueOf(512));
                ti.addScaleFactor(Integer.valueOf(1), new Integer[]{2, 4, 8, 16});
                info.addTile(ti, new TileInfo[0]);
            }
            if (reader.getWidth(0) >= 1024 && reader.getHeight(0) >= 1024) {
                TileInfo ti = new TileInfo(Integer.valueOf(1024));
                ti.addScaleFactor(Integer.valueOf(1), new Integer[]{2, 4, 8, 16});
                info.addTile(ti, new TileInfo[0]);
            }
        }
    }

    private ImageReader getReader(String identifier) throws ResourceNotFoundException, UnsupportedFormatException, IOException {
        if (this.imageSecurityService != null && !this.imageSecurityService.isAccessAllowed(identifier)) {
            throw new ResourceNotFoundException();
        }
        Resource res = null;
        try {
            res = this.resourceService.get(identifier, ResourcePersistenceType.RESOLVED, MimeType.MIME_IMAGE);
        }
        catch (ResourceIOException e) {
            throw new ResourceNotFoundException();
        }
        ImageInputStream iis = ImageIO.createImageInputStream(this.resourceService.getInputStream(res));
        ImageReader reader = (ImageReader)Streams.stream(ImageIO.getImageReaders(iis)).findFirst().orElseThrow(() -> new UnsupportedFormatException());
        reader.setInput(iis);
        return reader;
    }

    public void readImageInfo(String identifier, de.digitalcollections.iiif.model.image.ImageService info) throws UnsupportedFormatException, UnsupportedOperationException, ResourceNotFoundException, IOException {
        this.enrichInfo(this.getReader(identifier), info);
    }

    private ImageReadParam getReadParam(ImageReader reader, ImageApiSelector selector, double decodeScaleFactor) throws IOException {
        ImageReadParam readParam = reader.getDefaultReadParam();
        Dimension nativeDimensions = new Dimension(reader.getWidth(0), reader.getHeight(0));
        Rectangle targetRegion = selector.getRegion().resolve(nativeDimensions);
        Rectangle decodeRegion = new Rectangle((int)Math.ceil(targetRegion.getX() * decodeScaleFactor), (int)Math.ceil(targetRegion.getY() * decodeScaleFactor), (int)Math.ceil(targetRegion.getWidth() * decodeScaleFactor), (int)Math.ceil(targetRegion.getHeight() * decodeScaleFactor));
        readParam.setSourceRegion(decodeRegion);
        boolean didRotate = false;
        if (selector.getRotation().getRotation() != 0.0 && reader instanceof TurboJpegImageReader) {
            ((TurboJpegImageReadParam)readParam).setRotationDegree((int)selector.getRotation().getRotation());
            didRotate = true;
        }
        return readParam;
    }

    private DecodedImage readImage(String identifier, ImageApiSelector selector) throws IOException, ResourceNotFoundException, UnsupportedFormatException {
        ImageReader reader = this.getReader(identifier);
        if (selector.getRotation().getRotation() % 90.0 != 0.0) {
            throw new UnsupportedOperationException("Can only rotate by multiples of 90 degrees.");
        }
        Dimension nativeDimensions = new Dimension(reader.getWidth(0), reader.getHeight(0));
        Rectangle targetRegion = selector.getRegion().resolve(nativeDimensions);
        Dimension croppedDimensions = new Dimension(targetRegion.width, targetRegion.height);
        Dimension targetSize = selector.getSize().resolve(croppedDimensions, ImageApiProfile.LEVEL_TWO);
        double targetScaleFactor = (double)targetSize.width / targetRegion.getWidth();
        double decodeScaleFactor = 1.0;
        int imageIndex = 0;
        for (int idx = 0; idx < reader.getNumImages(true); ++idx) {
            double factor = (double)reader.getWidth(idx) / (double)nativeDimensions.width;
            double currentError = Math.abs(targetScaleFactor - factor);
            double bestError = Math.abs(targetScaleFactor - decodeScaleFactor);
            if (!(Math.abs(targetScaleFactor - factor) < Math.abs(targetScaleFactor - decodeScaleFactor))) continue;
            decodeScaleFactor = factor;
            imageIndex = idx;
        }
        Dimension decodeSize = new Dimension((int)(targetRegion.getWidth() * decodeScaleFactor), (int)(targetRegion.getHeight() * decodeScaleFactor));
        ImageReadParam readParam = this.getReadParam(reader, selector, decodeScaleFactor);
        int rotation = (int)selector.getRotation().getRotation();
        if (readParam instanceof TurboJpegImageReadParam && ((TurboJpegImageReadParam)readParam).getRotationDegree() != 0) {
            if (rotation == 90 || rotation == 270) {
                int h;
                int w = targetSize.width;
                targetSize.width = h = targetSize.height;
                targetSize.height = w;
            }
            rotation = 0;
        }
        try {
            return new DecodedImage(this, reader.read(imageIndex, readParam), targetSize, rotation);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private BufferedImage transformImage(BufferedImage inputImage, Dimension targetSize, int rotation, boolean mirror, ImageApiProfile.Quality quality) {
        boolean needsAdditionalScaling;
        BufferedImage img = inputImage;
        int inType = img.getType();
        boolean bl = needsAdditionalScaling = !new Dimension(img.getWidth(), img.getHeight()).equals(targetSize);
        if (needsAdditionalScaling) {
            img = Scalr.resize((BufferedImage)img, (Scalr.Method)Scalr.Method.BALANCED, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetSize.width, (int)targetSize.height, (BufferedImageOp[])new BufferedImageOp[0]);
        }
        if (rotation != 0) {
            Scalr.Rotation rot = null;
            switch (rotation) {
                case 90: {
                    rot = Scalr.Rotation.CW_90;
                    break;
                }
                case 180: {
                    rot = Scalr.Rotation.CW_180;
                    break;
                }
                case 270: {
                    rot = Scalr.Rotation.CW_270;
                }
            }
            img = Scalr.rotate((BufferedImage)img, (Scalr.Rotation)rot, (BufferedImageOp[])new BufferedImageOp[0]);
        }
        if (mirror) {
            img = Scalr.rotate((BufferedImage)img, (Scalr.Rotation)Scalr.Rotation.FLIP_HORZ, (BufferedImageOp[])new BufferedImageOp[0]);
        }
        int outType = -1;
        switch (1.$SwitchMap$de$digitalcollections$iiif$model$image$ImageApiProfile$Quality[quality.ordinal()]) {
            case 1: {
                outType = 10;
                break;
            }
            case 2: {
                outType = 12;
                break;
            }
            case 3: {
                outType = 5;
                break;
            }
            default: {
                outType = inType;
            }
        }
        if (outType != img.getType()) {
            BufferedImage newImg = new BufferedImage(img.getWidth(), img.getHeight(), outType);
            Graphics2D g2d = newImg.createGraphics();
            g2d.drawImage((Image)img, 0, 0, null);
            img = newImg;
            g2d.dispose();
        }
        return img;
    }

    public void processImage(String identifier, ImageApiSelector selector, OutputStream os) throws InvalidParametersException, UnsupportedOperationException, UnsupportedFormatException, ResourceNotFoundException, IOException {
        DecodedImage img;
        try {
            img = this.readImage(identifier, selector);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParametersException();
        }
        BufferedImage outImg = this.transformImage(img.img, img.targetSize, img.rotation, selector.getRotation().isMirror(), selector.getQuality());
        ImageWriter writer = (ImageWriter)Streams.stream(ImageIO.getImageWriters(new ImageTypeSpecifier(outImg), selector.getFormat().name())).findFirst().orElseThrow(() -> new UnsupportedFormatException());
        ImageOutputStream ios = ImageIO.createImageOutputStream(os);
        writer.setOutput(ios);
        writer.write(null, new IIOImage(outImg, null, null), null);
        writer.dispose();
        ios.flush();
    }
}

