/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.frontend.impl.springmvc.controller;

import de.digitalcollections.commons.server.HttpLoggingUtilities;
import de.digitalcollections.iiif.hymir.model.api.exception.InvalidDataException;
import de.digitalcollections.iiif.hymir.model.api.exception.ResolvingException;
import de.digitalcollections.iiif.hymir.presentation.business.api.v2.PresentationService;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ExtendedViewController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedViewController.class);
    @Autowired
    @Value(value="#{iiifVersions}")
    private Map<String, String> iiifVersions;
    @Autowired
    private PresentationService presentationService;

    @RequestMapping(value={"/presentation/{identifier}/view.html"}, method={RequestMethod.GET})
    public String viewExtendedPresentationGet(@PathVariable String identifier, Model model) {
        model.addAttribute("iiifVersions", (Object)this.iiifVersions);
        model.addAttribute("presentationUri", (Object)("/presentation/v2/" + identifier));
        return "mirador/view";
    }

    @RequestMapping(value={"/presentation/{version}/{objectIdentifier}/canvas/{canvasName}/view"}, method={RequestMethod.GET})
    public String viewCanvasGet(@PathVariable String version, @PathVariable String objectIdentifier, @PathVariable String canvasName, Model model, HttpServletRequest request) throws ResolvingException, InvalidDataException {
        HttpLoggingUtilities.addRequestClientInfoToMDC((HttpServletRequest)request);
        MDC.put((String)"manifestId", (String)objectIdentifier);
        MDC.put((String)"canvasName", (String)canvasName);
        String url = this.getOriginalUri(request).toString();
        String canvasId = url.substring(0, url.indexOf("/view"));
        String manifestId = url.substring(0, url.indexOf("/canvas")) + "/manifest";
        try {
            this.presentationService.getCanvas(objectIdentifier, canvasId);
            LOGGER.info("Serving Canvas for {}", (Object)canvasId);
            model.addAttribute("manifestId", (Object)manifestId);
            model.addAttribute("canvasId", (Object)canvasId);
        }
        catch (ResolvingException e) {
            LOGGER.info("Did not find canvas for {}", (Object)canvasId);
            throw e;
        }
        catch (InvalidDataException e) {
            LOGGER.error("Bad data for {}", (Object)objectIdentifier);
            throw e;
        }
        finally {
            MDC.clear();
        }
        model.addAttribute("iiifVersions", (Object)this.iiifVersions);
        return "mirador/viewCanvas";
    }

    private URI getOriginalUri(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().toString();
        String incomingScheme = URI.create(requestUrl).getScheme();
        String originalScheme = request.getHeader("X-Forwarded-Proto");
        if (originalScheme != null && !incomingScheme.equals(originalScheme)) {
            return URI.create(requestUrl.replaceFirst("^" + incomingScheme, originalScheme));
        }
        return URI.create(requestUrl);
    }
}

